package be.kava.jsfdemo.table;

import java.io.*;
import java.util.*;
import java.util.logging.*;

import javax.faces.event.*;

import org.apache.myfaces.trinidad.component.*;
import org.apache.myfaces.trinidad.model.*;

import be.kava.jsfdemo.contact.*;

public class TableBean implements Serializable {
	private static transient Logger logger = Logger
		.getLogger(TableBean.class.getName());

	private List<Contact> smallTable;
	private transient UIXTable smallTableBinding;
	private transient UIXTable adressenTableBinding;
	
	public List<Contact> getSmallTable() {
		return smallTable;
	}

	public void setSmallTable(List<Contact> smallTable) {
		this.smallTable = smallTable;
	}

	public TableBean() {
		logger.info("Inside constructor");

		smallTable =  new ArrayList<Contact>();

		int ctr = 0;
		/*
		Contact c1 = new Contact();
		c1.setId(++ctr);
		c1.setNaam("Vandam");
		c1.setVoornaam("Alain");
		c1.setLeeftijd("33");
		smallTable.add(c1);
		
		Contact c2 = new Contact();
		c2.setId(++ctr);
		c2.setNaam("Tanghe");
		c2.setVoornaam("Sammy");
		c2.setLeeftijd("36");
		smallTable.add(c2);
		
		Contact c3 = new Contact();
		c3.setId(++ctr);
		c3.setNaam("Laplasse");
		c3.setVoornaam("Bucky");
		c3.setLeeftijd("42");
		smallTable.add(c3);
		*/
		
		Contact c4 = new Contact();
		c4.setId(++ctr);
		c4.setNaam("Hombroeckx");
		c4.setVoornaam("Linda");
		c4.setLeeftijd("34");
		
		List<Adres> adressen = new ArrayList<Adres>();
		Adres a1 = new Adres();
		a1.setStraat("Huppeldepuplaan");
		a1.setNummer("49");
		a1.setGemeente("Gent");
		a1.setId(1);
		adressen.add(a1);
		
		Adres a2 = new Adres();
		a2.setStraat("Koekoekstraat");
		a2.setNummer("41");
		a2.setGemeente("Gent");
		a2.setId(2);
		adressen.add(a2);
		
		c4.setAdressen(adressen);
		
		smallTable.add(c4);
	}

	public void save(ActionEvent event) throws Exception {
		logger.info("Inside TableBean.save()");
		for (Iterator iter = smallTable.iterator(); iter.hasNext();) {
			Contact c = (Contact) iter.next();
			logger.info("Saved: " + c.getNaam() + ", " + c.getVoornaam() + ", " + c.getLeeftijd());
			List<Adres> adressen = c.getAdressen();
			if (adressen != null && adressen.size() > 0) {
				for (Adres adres : adressen) {
					logger.info("Adres: " + adres.getStraat() + adres.getNummer() + ", " + adres.getGemeente());
				}
			}
		}
	}
	
	public void addContact(ActionEvent event) throws Exception {
		logger.info("Inside TableBean.addContact()");
		Contact contact = new Contact();
		contact.setNaam("Nieuw");
		CollectionModel model = (CollectionModel)smallTableBinding.getValue();
		List<Contact> contacten = (List<Contact>) model.getWrappedData();
		int tmp = 0;
		for (Contact c : contacten) {
			if (c.getId() < tmp) {
				tmp = c.getId();
			}
		}
		contact.setId(--tmp);
		logger.info("Id: " + tmp);
		contacten.add(contact);
	}
	
	public void addAdres(ActionEvent event) throws Exception {
		logger.info("Inside TableBean.addAdres()");
		Adres adres = new Adres();
		CollectionModel model = (CollectionModel)adressenTableBinding.getValue();
		List<Adres> adressen = (List<Adres>) model.getWrappedData();
		int tmp = 0;
		for (Adres a : adressen) {
			if (a.getId() < tmp) {
				tmp = a.getId();
			}
		}
		adres.setId(--tmp);
		logger.info("Id: " + tmp);
		adressen.add(adres);
	}
	
	public void removeContact(ActionEvent event) throws Exception {
		logger.info("Inside TableBean.removeContact()");

		Contact contact = (Contact) smallTableBinding.getRowData();
		logger.info("Contact to be removed: " + contact.getNaam());
		logger.info("smallTableBinding.getValue(): " + smallTableBinding.getValue().getClass().getName());
		CollectionModel model = (CollectionModel)smallTableBinding.getValue();
		List contacten = (List) model.getWrappedData();
		contacten.remove(contact);
	}

	public void removeAdres(ActionEvent event) throws Exception {
		logger.info("Inside TableBean.removeAdres()");

		Adres adres = (Adres) adressenTableBinding.getRowData();
		logger.info("Contact to be removed: " + adres.getStraat());
		logger.info("smallTableBinding.getValue(): " + smallTableBinding.getValue().getClass().getName());
		CollectionModel model = (CollectionModel)adressenTableBinding.getValue();
		List adressen = (List) model.getWrappedData();
		adressen.remove(adres);
	}

	public UIXTable getSmallTableBinding() {
		return smallTableBinding;
	}

	public void setSmallTableBinding(UIXTable smallTableBinding) {
		this.smallTableBinding = smallTableBinding;
	}

	public UIXTable getAdressenTableBinding() {
		return adressenTableBinding;
	}

	public void setAdressenTableBinding(UIXTable adressenTableBinding) {
		this.adressenTableBinding = adressenTableBinding;
	}

}
