/*
 * This file is part of TelepathyQt4
 *
 * Copyright (C) 2010 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <TelepathyQt4/Channel>

namespace Tp {

/**
 * \class TubeChannel
 * \headerfile TelepathyQt4/tube-channel.h <TelepathyQt4/TubeChannel>
 *
 * \brief A class representing an abstract Tube
 *
 * \c TubeChannel is an high level wrapper for managing Telepathy interface
 * org.freedesktop.Telepathy.Channel.Interface.Tube.
 * A tube is a mechanism for arbitrary data transfer between two or more IM users,
 * used to allow applications on the users' systems to communicate without having
 * to establish network connections themselves.
 *
 * Please note that you can't create an abstract tube: you should use one of its
 * subclasses instead. At the moment, \c StreamTube and \c DBusTube are available.
 *
 * For more details, please refer to Telepathy spec.
 */
class TubeChannel : public Channel
{
    Q_OBJECT
    Q_DISABLE_COPY(TubeChannel)

public:
    /**
     * Feature used in order to monitor the tube state.
     *
     * tubeStateChanged will be emitted when the tube state changes.
     */
    static const Feature FeatureTubeState;

    virtual ~TubeChannel();

    /**
     * \returns The State of the tube in this channel.
     */
    TubeState tubeState() const;
    /**
     * \returns The type of this tube.
     */
    TubeType tubeType() const;

    /**
     * \returns A dictionary of arbitrary parameters. Please refer to the spec for more details.
     */
    QVariantMap parameters() const;

protected:
    TubeChannel(const ConnectionPtr &connection, const QString &objectPath,
            const QVariantMap &immutableProperties);

Q_SIGNALS:
    void tubeStateChanged(TubeState newstate);
};

}
