#include <TelepathyQt4/PendingConnection>
#include <TelepathyQt4/PendingOperation>
#include <TelepathyQt4/PendingReady>
#include <TelepathyQt4/StreamedMediaChannel>

#include "CallHandler.h"

CallHandler::CallHandler( QObject *parent )
            : QObject( parent )
{
    m_callStatus = CALL_STATUS_IDLE;
    m_connectionStatus = CONNECTION_STATUS_DISCONNECTED;
    m_ConnManager = Tp::ConnectionManager::create( PROTOCOL_SOFIASIP );
    connect( m_ConnManager->becomeReady(), SIGNAL(finished(Tp::PendingOperation *)),
            SLOT(onCMReady(Tp::PendingOperation *)));
}

CallHandler::~CallHandler()
{
    if( m_connection )
    {
        m_connection->requestDisconnect();
    }
}

QString CallHandler::getConnMgrFlags( uint flag )
{
    QString str = QString();
    if( flag & CONN_MGR_PARAM_FLAGS_REQUIRED )
        str += "flag is required \n";
    if( flag & CONN_MGR_PARAM_FLAGS_REGISTER )
        str += "flag is register \n";
    if( flag & CONN_MGR_PARAM_FLAGS_HAS_DEFAULT )
        str += "flag has default \n";
    if( flag & CONN_MGR_PARAM_FLAGS_SECRIET )
        str += "flag is secriet \n";
    if( flag & CONN_MGR_PARAM_FLAGS_BUS_PROPERTY )
        str += "flag has bus property";

    return str;
}

void CallHandler::onCMReady( Tp::PendingOperation *op )
{
    qDebug() << "CallHandler::onCMReady Entry";

    if( op->isError() )
    {
        qDebug() << "connection manager can't become ready.";
        return;
    }
    AccountSipParameter sipParam;
    sipParam.m_accountName = "Ekiga.net";
    sipParam.m_authUser = "funpig";
    sipParam.m_password = "77423CZ";
    sipParam.m_registrar = "ekiga.net";
    sipParam.m_proxyHost = "ekiga.net";
//    sipParam.m_stunServer = "stun.ekiga.net";
//    sipParam.m_extraAuthUser = "funpig";
//    sipParam.m_extraAuthPassword = "77423CZ";
    QVariantMap param = sipParam.getParam();

    Tp::PendingConnection *pconn = m_ConnManager->requestConnection( PROTOCOL_SIP, param );
    connect( pconn, SIGNAL( finished( Tp::PendingOperation * )),
            SLOT(onConnectionCreated(Tp::PendingOperation *)));

    qDebug() << "CallHandler::onCMReady Exit";
}

void CallHandler::onConnectionCreated( Tp::PendingOperation *op )
{
    qDebug() << "CallHandler::onConnectionCreated Entry";

    if( op->isError() )
    {
        qDebug() << "connection create failed.";
        return;
    }
    Tp::PendingConnection *pconn = qobject_cast<Tp::PendingConnection *>(op);
    Tp::ConnectionPtr conn = pconn->connection();
    m_connection = conn;
    connect( conn->requestConnect(Tp::Connection::FeatureSelfContact),
            SIGNAL( finished(Tp::PendingOperation *)),
            SLOT( onConnectoinConnected( Tp::PendingOperation * )));
    connect( conn.data(), SIGNAL( invalidated( Tp::DBusProxy *, const QString &, const QString & )),
            SLOT( onConnectionInvalidated( Tp::DBusProxy *, const QString &, const QString & ) ));

    qDebug() << "CallHandler::onConnectionCreated Exit";
}

void CallHandler::onConnectoinConnected( Tp::PendingOperation *op )
{
    qDebug() << "CallHandler::onConnectoinConnected Entry";

    if( op->isError() )
    {
        qDebug() << "Connection can't connected.";
        return;
    }
    Tp::PendingReady *pr = qobject_cast<Tp::PendingReady *>(op);
    Tp::ConnectionPtr conn = Tp::ConnectionPtr( qobject_cast<Tp::Connection *>( pr->object() ) );
    if( conn->interfaces().contains( Tp::TELEPATHY_INTERFACE_CONNECTION_INTERFACE_CAPABILITIES ) )
    {
        Tp::CapabilityPair caps = {
            Tp::TELEPATHY_INTERFACE_CHANNEL_TYPE_STREAMED_MEDIA,
            Tp::ChannelMediaCapabilityAudio |
            Tp::ChannelMediaCapabilityVideo |
            Tp::ChannelMediaCapabilityNATTraversalSTUN
            };
        qDebug() << "set interface capability";
        conn->capabilitiesInterface()->AdvertiseCapabilities( Tp::CapabilityPairList() << caps, QStringList() );
    }

    if( conn->interfaces().contains( Tp::TELEPATHY_INTERFACE_CONNECTION_INTERFACE_REQUESTS ))
    {
        qDebug() << "connect to connection.interface.newchannel";
        connect( conn->requestsInterface(), SIGNAL( Newchannels(const Tp::ChannelDetailList &) ),
                SLOT( onNewChannels( const Tp::ChannelDetailList &) ));
    }

    qDebug() << "CallHandler::onConnectoinConnected Exit";
}

void CallHandler::onConnectionInvalidated( Tp::DBusProxy *proxy, const QString &errorName, const QString &errorMessage )
{
    qDebug() << "CallHandler::onConnectionInvalidated Entry";

    qDebug() << "connection is invalidated " << errorName << "-" << errorMessage;
    m_connection.reset();

    qDebug() << "CallHandler::onConnectionInvalidated Exit";
}

void CallHandler::onNewChannels( const Tp::ChannelDetailsList &channels )
{
    qDebug() << "CallHandler::onNewChannels Entry";

    foreach( const Tp::ChannelDetails &detail, channels )
    {
        QString channelType = detail.properties.value( QLatin1String( Tp::TELEPATHY_INTERFACE_CHANNEL ".ChannelType") ).toString();
        bool requested = detail.properties.value( QLatin1String( Tp::TELEPATHY_INTERFACE_CHANNEL ".Requested") ).toBool();
        qDebug() << "channeltype: " << channelType;
        qDebug() << "requested: " << requested;

        if( !requested && channelType == Tp::TELEPATHYE_INTERFACE_CHANNEL_TYPE_STREAMED_MEDIA )
        {
            Tp::StreamedMediaChannelPtr channel = Tp::StreamedMediaChannel::create( m_connection, detail.channel.path(),
                                                                                   detail.properties );
        }
    }

    qDebug() << "CallHandler::onNewChannels Exit";
}

void CallHandler::onStatusChanged( uint status, uint reason )
{
    qDebug() << "CallHandler::onStatusChanged Entry";

    qDebug() << "Connection state changed to" << status << "- reason" << reason;
    if( status == CONNECTION_STATUS_CONNECTED )
    {
        qDebug() << "conneciton is connected.";
    }

    qDebug() << "CallHandler::onStatusChanged Exit";
}
