#include "AccountSipParameter.h"

AccountSipParameter::AccountSipParameter()
{
    m_accountName = QString();
    m_authUser = QString();
    m_password = QString();
    m_registrar = QString();
    m_proxyHost = QString();
    m_port = 5060;
    m_transport = "auto";
    m_looseRouting = false;
    m_discoverBinding = true;
    m_keepaliveMechanism = QString();
    m_keepaliveInterval = 3600;
    m_discoverStun = true;
    m_stunServer = QString();
    m_stunPort = 3478;
    m_localIpAddress = QString();
    m_localPort = 0;
    m_extraAuthUser = QString();
    m_extraAuthPassword = QString();
}

AccountSipParameter::AccountSipParameter( AccountSipParameter &param )
{
    m_accountName = param.m_accountName;
    m_authUser = param.m_authUser;
    m_password = param.m_password;
    m_registrar = param.m_registrar;
    m_proxyHost = param.m_proxyHost;
    m_port = param.m_port;
    m_transport = param.m_transport;
    m_looseRouting = param.m_looseRouting;
    m_discoverBinding = param.m_discoverBinding;
    m_keepaliveMechanism = param.m_keepaliveMechanism;
    m_keepaliveInterval = param.m_keepaliveInterval;
    m_discoverStun = param.m_discoverStun;
    m_stunServer = param.m_stunServer;
    m_stunPort = param.m_stunPort;
    m_localIpAddress = param.m_localIpAddress;
    m_localPort = param.m_localPort;
    m_extraAuthUser = param.m_extraAuthUser;
    m_extraAuthPassword = param.m_extraAuthPassword;
}

AccountSipParameter::~AccountSipParameter()
{
    //dtor
}

QVariantMap AccountSipParameter::getParam() const
{
    QVariantMap map;
    map["account"]             = QVariant( m_accountName );
    map["auth-user"]           = QVariant( m_authUser );
    map["password"]            = QVariant( m_password );
    map["registrar"]           = QVariant( m_registrar );
    map["proxy-host"]          = QVariant( m_proxyHost );
    map["port"]                = QVariant( (uint)m_port );
    map["transport"]           = QVariant( m_transport );
    map["loose-routing"]       = QVariant( m_looseRouting );
    map["discover-binding"]    = QVariant( m_discoverBinding );
    map["keepalive-mechanism"] = QVariant( m_keepaliveMechanism );
    map["keepalive-interval"]  = QVariant( (int)m_keepaliveInterval );
    map["discover-stun"]       = QVariant( m_discoverStun );
    map["stun-server"]         = QVariant( m_stunServer );
    map["stun-port"]           = QVariant( (uint)m_stunPort );
    map["local-ip-address"]    = QVariant( m_localIpAddress );
    map["local-port"]          = QVariant( (uint)m_localPort );
    map["extra-auth-user"]     = QVariant( m_extraAuthUser );
    map["extra-auth-password"] = QVariant( m_extraAuthPassword );

    return map;
}
