#include <QApplication>
#include <QFont>
#include <QPushButton>
#include <QtCore/QDebug>
#include <QtDBus>

#include "common.h"
#include "ParameterDefinition.h"
#include "CallHandler.h"


static void registerTypes()
{
    static bool registered = false;
    if( !registered )
    {
        qDBusRegisterMetaType<QVariantMap>();
        qDBusRegisterMetaType<ParameterDefinition>();
        qDBusRegisterMetaType<ParameterDefinitionList>();
        registered = true;
    }
}

/*
void dbus_init()
{
    qDebug() << "dbus init in";

    qDBusRegisterMetaType<ParameterDefinition>();
    qDBusRegisterMetaType<ParameterDefinitionList>();

    QDBusConnection bus = QDBusConnection::sessionBus();
    if( !bus.isConnected() )
    {
        qDebug() << "no connection";
        return;
    }

    QDBusInterface cm_iface( CONNECTION_MANAGER_SERVICE_NAME + "sofiasip",
                               CONNECTION_MANAGER_PATH_NAME + "sofiasip",
                               CONNECTION_MANAGER_INTERFACE_NAME, bus);
    QDBusReply<QStringList> reply = cm_iface.call( "ListProtocols" );
    qDebug() << "reply count = " << reply.value().count();
    QString protocol;
    foreach( protocol, reply.value() )
    {
        qDebug() << "protocol = " << protocol;

        QDBusReply<ParameterDefinitionList> parameters = cm_iface.call( "GetParameters", protocol );
        if( parameters.isValid() )
            qDebug() << "parameters is valid";
        else
            qDebug() << "parameters is invalid";
        qDebug() << "parameters count = " << parameters.value().count();
//        foreach( ParameterDefinition para, parameters.value() )
//        {
//            qDebug() << "parameter 1 = " << para.name;
//            qDebug() << "parameter 2 = " << getConnMgrFlags( para.flags );
//            qDebug() << "parameter 3 = " << para.signature;
//            qDebug() << "parameter 4 = " << para.defaultValue.variant();
//        }
    }

    AccountSipParameter sipParam;
    sipParam.m_accountName = "Ekiga.net";
    sipParam.m_authUser = "funpig";
    sipParam.m_password = "77423CZ";
    sipParam.m_registrar = "ekiga.net";
    sipParam.m_proxyHost = "ekiga.net";
//    sipParam.m_stunServer = "stun.ekiga.net";
//    sipParam.m_extraAuthUser = "funpig";
//    sipParam.m_extraAuthPassword = "77423CZ";
    QVariantMap param = sipParam.getParam();

    QList<QVariant> argumentList;
    argumentList << QVariant::fromValue(protocol) << QVariant::fromValue(param);
    QDBusPendingReply<QString, QDBusObjectPath> pendingreply = cm_iface.asyncCallWithArgumentList(QLatin1String("RequestConnection"), argumentList);
    pendingreply.waitForFinished();

    if( !pendingreply.isValid() )
    {
        QDBusError error = pendingreply.error();
        qDebug() << "request connection error. error type: " << error.type() << "error name:" << error.name();

        return;
    }

    QString serviceName = pendingreply.argumentAt<0>();
    QDBusObjectPath objectPath = pendingreply.argumentAt<1>();

    qDebug() << "service name:" << serviceName << "obj path:" << objectPath.path();
//    CallHandler call;
//
//    Connection conn( serviceName, objectPath.path(), bus );
//    QObject::connect( &conn, SIGNAL( StatusChanged( uint, uint ) ), &call, SLOT( onStatusChanged( uint,uint ) ) );
//    conn.Connect();

    qDebug() << "dbus init out";
}
*/

int main(int argc, char* argv[])
{
    QApplication app(argc, argv);

    registerTypes();

    QPushButton quit("Quit");

    quit.resize(75, 30);
    quit.setFont(QFont("Times", 18, QFont::Bold));

    QObject::connect(&quit, SIGNAL(clicked()), &app, SLOT(quit()));

    quit.show();

//    dbus_init();

    CallHandler call( &quit );

    return app.exec();
}
