#ifndef PARAMETERDEFINITION_H
#define PARAMETERDEFINITION_H

#include <QApplication>
#include <QtDBus>

class ParameterDefinition
{
public:
    QString name;
    uint flags;
    QString signature;
    QDBusVariant defaultValue;
};
typedef QList<ParameterDefinition> ParameterDefinitionList;
Q_DECLARE_METATYPE(ParameterDefinition)
Q_DECLARE_METATYPE(ParameterDefinitionList)

const QDBusArgument &operator>>(const QDBusArgument &argument, ParameterDefinition &param);
QDBusArgument &operator<<(QDBusArgument &argument, const ParameterDefinition &param);

#endif // PARAMETERDEFINITION_H
