#ifndef ERRORHANDLER_H
#define ERRORHANDLER_H

#include <QtCore/QObject>
#include <QtDBus/QDBusConnection>
#include <TelepathyQt4/Connection>

class ErrorHandler : public QObject
{
    Q_OBJECT

    public:
        ErrorHandler();
        ErrorHandler( Tp::ConnectionPtr conn, const QDBusConnection &bus, QObject *parent = 0 );
        ~ErrorHandler();
    public Q_SLOTS:
        // when error occur
        void onErrorOccur( uint error, uint reason );
    protected:
    private:
        uint m_error;
        uint m_reason;
        Tp::ConnectionPtr m_connection;
        QDBusConnection m_bus;
};

#endif // ERRORHANDLER_H
