#ifndef CALLHANDLER_H
#define CALLHANDLER_H

#include <TelepathyQt4/Types>
#include <TelepathyQt4/Connection>
#include <TelepathyQt4/ConnectionManager>

#include "common.h"
#include "AccountSipParameter.h"

class CallHandler : public QObject
{
    Q_OBJECT

    public:
        CallHandler( QObject *parent = 0 );
        ~CallHandler();

        // get flag of ConnecitonManager
        QString getConnMgrFlags( uint flag );

    signals:
        void errorOccur( uint error, uint reason );

    public Q_SLOTS:
        void onCMReady( Tp::PendingOperation * );
        void onConnectionCreated( Tp::PendingOperation * );
        void onConnectoinConnected( Tp::PendingOperation * );
        void onConnectionInvalidated( Tp::DBusProxy *, const QString &, const QString & );
        void onNewChannels( const Tp::ChannelDetailsList & );
        // when status of call changed.
        void onStatusChanged( uint status, uint reason );

    protected:
    private:
        Tp::ConnectionManagerPtr m_ConnManager;
        Tp::ConnectionPtr m_connection;
        uint m_callStatus;
        uint m_connectionStatus;
};

#endif // CALLHANDLER_H
