#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <errno.h>

#define _GNU_SOURCE
#include <poll.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ioctl.h>

int prep_source(const char *path)
{
     int fd;

     fd = open(path, O_RDONLY | O_NONBLOCK);
     assert(fd >= 0);

     return fd;
}


int main(int argc, char *argv[])
{
     int r;
     char buf[4096];
     struct pollfd pfd;

     pfd.fd = prep_source("/dev/log_main");
     pfd.events = POLLIN;

     while (1) {
	  int bytes;

	  r = poll(&pfd, 1, 100000000);
	  if (r < 0) {
	       if (errno == EAGAIN)
		    continue;

	       perror("poll");
	       abort();
	  }

	  pfd.revents = 0;
	  
	  for (bytes = 0; r > 0; ) {

	       r = read(pfd.fd, buf, 4096);
	       if (r < 0 && errno != EAGAIN) {
		    perror("read");
		    abort();
	       }

	       bytes -= r;
	  }

     }

     return 0;
}
