
import gtk, pygtk, gobject

#builder = gtk.Builder()

class Display(object):
    def __init__(self):
        self.builder = gtk.Builder()
        self.builder.add_objects_from_file("gui.glade", ["Display_Window"])
                
        #get widgets
        self.display_window = self.builder.get_object("Display_Window")
        #self.display_window = gtk.Window()
        self.display_text = self.builder.get_object("Display_Text")
        self.disable_progress = self.builder.get_object("DisableProgress")
        
        self.builder.connect_signals(self)
        
        #set initials
        self.timer = None
        self.progress = 0
        
        #timer stuff
        self.timer = gobject.timeout_add(500, self.on_progress_timer)
        
        #set icon
        pixbuf = self.display_window.render_icon(gtk.STOCK_PREFERENCES, gtk.ICON_SIZE_MENU)
        self.display_window.set_icon(pixbuf)
        #go on
        self.display_window.show()
        
    def on_Display_Window_delete_event(self,widget,data=None):
	gobject.source_remove(self.timer)        
	self.display_window.destroy()
        
        
    def on_progress_timer(self): #timing for window destroy
        seconds = 2
        self.progress = self.progress + ( (1. / seconds) / 2. )
        new_val = self.progress
            
        if new_val > 1.0:
            # Do Exit        #new_val = 0.0
            self.on_Display_Window_delete_event(self)
            return False
        # Set the new value
        print self.progress
        return True
    
    def on_DisableProgress_button_press_event(self, widget, event):
        #if progressbar clicked, timer will stop
        self.progress_paused = True
        gobject.source_remove(self.timer)

class xTimer(object):
    
    def __init__(self):
        self.enabled = True
            
    def on_time(self):
        if self.enabled == False : return False 
        print "OnTime"
        bb = Display()  # create window
        
        return True
    
    def start(self):
        self.enabled = True
        seconds = 5
        gobject.timeout_add_seconds(seconds, self.on_time)
        
    def stop(self):
        self.enabled = False

def main():
    a = xTimer()
    a.start()
    gtk.main()
    
if __name__ == '__main__':
    main()
