
define wordpress::install($dir = "/var/www") {

	$top = "$dir/$title"

	include lamp::php	# to install and configure apache, mysql, php
	Class[ "lamp::php" ] -> File[ "$top" ]

	file { "$top":
		ensure => directory,
		owner  => www-data,
		group  => www-data,
		mode   => 2775,
	}

	exec { "true $title && wget -O - $upstream | tar xzf - --xform 's,wordpress/,,'":
		cwd         => "$top",
		creates     => "$top/license.txt",
		before      => File[ "$top/setup.mysql" ],
	}

	file { "$top/setup.mysql":
		content   => template("wordpress/setup.mysql"),
		mode      => 775,
	}

	file { "$top/wp-config.php":
		content   => template("wordpress/wp-config.php"),
		mode      => 660,
	}

}

define wordpress::setup($dir = "/var/www") {

	$top = "$dir/$title"

	exec { "$top/setup.mysql '$admin_pass' '$wp_pass' >> $top/setup.mysql.log 2>&1":
		refreshonly => true,
		subscribe   => File[ "$top/setup.mysql" ],
	}

}

define wordpress($upstream = "http://wordpress.org/latest.tar.gz") {

	$adminname    = "mysql"
	$adminpass    = "freesas"
	$wp_user      = "www-data"
	$wp_pass      = "freesas"
	$wp_host      = "localhost"
	$wp_prefix    = "wp_$title"
	$databasename = "wordpress_$title"

	wordpress::install { "$title": }
	wordpress::setup   { "$title": }

	Wordpress::Install[ "$title" ] -> Wordpress::Setup  [ "$title" ]
}

