#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "netSnmpPrvTable.h"
#include <stdio.h>
#include <string.h>

/** Initializes the netSnmpPrvTable module */
void
init_netSnmpPrvTable(void)
{
    /*
     * here we initialize all the tables we're planning on supporting 
     */
    initialize_table_netSnmpPrvTable();
}


/** Initialize the netSnmpPrvTable table by defining its contents and how it's structured */
void
initialize_table_netSnmpPrvTable(void)
{
    const oid       netSnmpPrvTable_oid[] =
        { 1, 3, 6, 1, 4, 1, 8072, 9999, 9999, 1, 2 };
    const size_t    netSnmpPrvTable_oid_len =
        OID_LENGTH(netSnmpPrvTable_oid);
    netsnmp_handler_registration *reg;
    netsnmp_tdata  *table_data;
    netsnmp_table_registration_info *table_info;
    netsnmp_cache  *cache;
    	
	printf("Initialise table \n");
    DEBUGMSGTL(("netSnmpPrvTable:init",
                "initializing table netSnmpPrvTable\n"));

    reg =
        netsnmp_create_handler_registration("netSnmpPrvTable",
                                            netSnmpPrvTable_handler,
                                            netSnmpPrvTable_oid,
                                            netSnmpPrvTable_oid_len,
                                            HANDLER_CAN_RONLY);

    table_data = netsnmp_tdata_create_table("netSnmpPrvTable", 0);
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    netsnmp_table_helper_add_indexes(table_info, ASN_INTEGER,   /* index: netSnmpPrvIndex */
                                     0);

    table_info->min_column = COLUMN_NETSNMPPRVOWD;
    table_info->max_column = COLUMN_NETSNMPPRVATR;
    
    netsnmp_tdata_register(reg, table_data, table_info);
				//changed NETSNMPPRVTABLE_TIMEOUT with -1
  				
	cache = netsnmp_cache_create(-1,
                                 netSnmpPrvTable_load,
                                 netSnmpPrvTable_free, netSnmpPrvTable_oid,
                                 netSnmpPrvTable_oid_len);
	printf("Cache status (init afer create) %d\n",netsnmp_cache_check_expired(cache));
   cache->magic = (void *) table_data;

    cache->flags = NETSNMP_CACHE_PRELOAD;
	    
 	
    printf("cache created: %d\n", (int) &cache);
	printf("Cache status (init before inject) %d\n",netsnmp_cache_check_expired(cache));
						///change 'GET' with 'get'
    netsnmp_inject_handler_before(reg, netsnmp_cache_handler_get(cache),
                                  TABLE_DATA_NAME);

	printf("Cache status (init after inject) %d\n",netsnmp_cache_check_expired(cache));

////////////
	printf("table refistered: %d\n", (int) &table_info);
/////

   
}

  /*
     * Typical data structure for a row entry 
     */
struct netSnmpPrvTable_entry {
    /*
     * Index values 
     */
    long            netSnmpPrvIndex;

    /*
     * Column values 
     */
    char            netSnmpPrvOWD[15];   ///
    size_t          netSnmpPrvOWD_len;
    char            netSnmpPrvATR[15];   ///
    size_t          netSnmpPrvATR_len;

    int             valid;
};

/*
 * create a new row in the table 
 */
netsnmp_tdata_row *
netSnmpPrvTable_createEntry(netsnmp_tdata * table_data,
                            long netSnmpPrvIndex)
{
    struct netSnmpPrvTable_entry *entry;
    netsnmp_tdata_row *row;

    entry = SNMP_MALLOC_TYPEDEF(struct netSnmpPrvTable_entry);
    if (!entry)
	{
	printf("creating entry fail: \n");
        return NULL;
	}

////////////
	printf("creating entry: %d\n", (int) &entry);
/////

    row = netsnmp_tdata_create_row();
    if (!row) {
        SNMP_FREE(entry);
        return NULL;
    }
    row->data = entry;

    entry->netSnmpPrvIndex = netSnmpPrvIndex;
    netsnmp_tdata_row_add_index(row, ASN_INTEGER,
                                &(entry->netSnmpPrvIndex),
                                sizeof(entry->netSnmpPrvIndex));
    netsnmp_tdata_add_row(table_data, row);


    return row;
}

/*
 * remove a row from the table 
 */
void
netSnmpPrvTable_removeEntry(netsnmp_tdata * table_data,
                            netsnmp_tdata_row * row)
{
    struct netSnmpPrvTable_entry *entry;

    if (!row)
        return;                 /* Nothing to remove */
    entry = (struct netSnmpPrvTable_entry *)
        netsnmp_tdata_remove_and_delete_row(table_data, row);



////////////
	printf("removing entry: %d\n", (int) &entry);
/////


    if (entry)
        SNMP_FREE(entry);       /* XXX - release any other internal resources */
}



//////////////
#define STRMAX 15
////////////


int
netSnmpPrvTable_load(netsnmp_cache * cache, void *vmagic)
{
    netsnmp_tdata  *table = (netsnmp_tdata *) vmagic;
    struct netSnmpPrvTable_entry *entry=NULL;
 	
	 printf("Riding files eth0_delay and eth0_datarate !!!!! \n");
	printf("Cache status (loadstart) %d\n",netsnmp_cache_check_expired(cache));
    	FILE *result;
        char lineowd[10],lineatr[10];
        
	result=fopen("/tmp/eth0_delay.out","r");
        if (result==NULL) printf("Cannot open file result\n");
        else
        {
                
                while(!feof(result))
                {
                        fscanf(result,"%s",lineowd);
                      
                }
		fclose(result);
	}
	
	char saveowd[10]="";
	strcpy(saveowd,lineowd);
	
	result=fopen("/tmp/eth0_datarate.out","r");
        if (result==NULL) printf("Cannot open file result\n");
        else
        {
                
                while(!feof(result))
                {
			fscanf(result,"%s",lineatr);
			
                        
              	}
                fclose(result);
        }
	
	printf("%s\n",lineatr);
	printf("%s\n",saveowd);
	printf("%d\n",strlen(saveowd));
    
	long netSnmpPrvIndex=1;
    	netsnmp_tdata_row *this;

	printf("loading cache: %d\n" ,(int) &cache);

      
	this = netSnmpPrvTable_createEntry(table, netSnmpPrvIndex);


	if (this && this->data)
	{
		entry=this->data;	
		strcpy(entry->netSnmpPrvOWD,saveowd);
		entry->netSnmpPrvOWD_len=strlen(saveowd);
		strcpy(entry->netSnmpPrvATR,lineatr);
		entry->netSnmpPrvATR_len=strlen(lineatr);
	}
	
	printf("Cache status (loadend) %d\n",netsnmp_cache_check_expired(cache));
	return ((int)entry);
}

/// modified int with void
void
netSnmpPrvTable_free(netsnmp_cache * cache, void *vmagic)
{
    netsnmp_tdata  *table = (netsnmp_tdata *) vmagic;
    netsnmp_tdata_row *this;
	
	printf("Cache status (free) %d\n",netsnmp_cache_check_expired(cache));
	printf("freeing cache: %d\n",(int) &cache);

    //while ((this = netsnmp_tdata_get_first_row(table))) 
   while ((this = (void *) netsnmp_tdata_row_first(table))) 
    {
        netsnmp_tdata_remove_and_delete_row(table, this);
    }

	//calling the load routine from here didn't work
	//netSnmpPrvTable_load(cache,vmagic);
	
}

/** handles requests for the netSnmpPrvTable table */
int
netSnmpPrvTable_handler(netsnmp_mib_handler *handler,
                        netsnmp_handler_registration *reginfo,
                        netsnmp_agent_request_info *reqinfo,
                        netsnmp_request_info *requests)
{

    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
   // netsnmp_tdata  *table_data;
   // netsnmp_tdata_row *table_row;
    struct netSnmpPrvTable_entry *table_entry;
    //int             ret;
DEBUGMSGTL(("netSnmpPrvTable:handler", "Processing request (%d)\n",
                reqinfo->mode));
	
	printf("handling request: %d\n", reqinfo->mode);

    switch (reqinfo->mode) {
      case MODE_GET:
        for (request = requests; request; request = request->next) {
            table_entry = (struct netSnmpPrvTable_entry *)
                netsnmp_tdata_extract_entry(request);
            table_info = netsnmp_extract_table_info(request);

            switch (table_info->colnum) {
            case COLUMN_NETSNMPPRVOWD:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
		snmp_set_var_typed_value(request->requestvb, 
					 ASN_OCTET_STR,
                                         (u_char *) 
					 table_entry->netSnmpPrvOWD,
                                         table_entry->netSnmpPrvOWD_len);
                break;
            case COLUMN_NETSNMPPRVATR:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
		snmp_set_var_typed_value(request->requestvb, 
					 ASN_OCTET_STR,
                                         (u_char *) 
        				 table_entry->netSnmpPrvATR,
                                         table_entry->netSnmpPrvATR_len);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;

    }
    return SNMP_ERR_NOERROR;
}
