/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 14170 $ of $ 
 *
 * $Id:$
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "ifTable.h"


#include "ifTable_data_access.h"

/** @ingroup interface
 * @addtogroup data_access data_access: Routines to access data
 *
 * These routines are used to locate the data used to satisfy
 * requests.
 * 
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table ifTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * IF-MIB::ifTable is subid 2 of interfaces.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.2.2, length: 8
 */

/**
 * initialization for ifTable data access
 *
 * This function is called during startup to allow you to
 * allocate any resources you need for the data table.
 *
 * @param ifTable_reg
 *        Pointer to ifTable_registration
 *
 * @retval MFD_SUCCESS : success.
 * @retval MFD_ERROR   : unrecoverable error.
 */
int
ifTable_init_data(ifTable_registration * ifTable_reg)
{
    DEBUGMSGTL(("verbose:ifTable:ifTable_init_data", "called\n"));

    /*
     * TODO:303:o: Initialize ifTable data.
     */
    /*
     ***************************************************
     ***             START EXAMPLE CODE              ***
     ***---------------------------------------------***/
    /*
     * if you are the sole writer for the file, you could
     * open it here. However, as stated earlier, we are assuming
     * the worst case, which in this case means that the file is
     * written to by someone else, and might not even exist when
     * we start up. So we can't do anything here.
     */
    /*
     ***---------------------------------------------***
     ***              END  EXAMPLE CODE              ***
     ***************************************************/

    return MFD_SUCCESS;
}                               /* ifTable_init_data */

/**
 * container overview
 *
 */

/**
 * container initialization
 *
 * @param container_ptr_ptr A pointer to a container pointer. If you
 *        create a custom container, use this parameter to return it
 *        to the MFD helper. If set to NULL, the MFD helper will
 *        allocate a container for you.
 * @param  cache A pointer to a cache structure. You can set the timeout
 *         and other cache flags using this pointer.
 *
 *  This function is called at startup to allow you to customize certain
 *  aspects of the access method. For the most part, it is for advanced
 *  users. The default code should suffice for most cases. If no custom
 *  container is allocated, the MFD code will create one for your.
 *
 *  This is also the place to set up cache behavior. The default, to
 *  simply set the cache timeout, will work well with the default
 *  container. If you are using a custom container, you may want to
 *  look at the cache helper documentation to see if there are any
 *  flags you want to set.
 *
 * @remark
 *  This would also be a good place to do any initialization needed
 *  for you data source. For example, opening a connection to another
 *  process that will supply the data, opening a database, etc.
 */
void
ifTable_container_init(netsnmp_container ** container_ptr_ptr,
                       netsnmp_cache * cache)
{
    DEBUGMSGTL(("verbose:ifTable:ifTable_container_init", "called\n"));

    if (NULL == container_ptr_ptr) {
        snmp_log(LOG_ERR,
                 "bad container param to ifTable_container_init\n");
        return;
    }

    /*
     * For advanced users, you can use a custom container. If you
     * do not create one, one will be created for you.
     */
    *container_ptr_ptr = NULL;

    if (NULL == cache) {
        snmp_log(LOG_ERR, "bad cache param to ifTable_container_init\n");
        return;
    }

    /*
     * TODO:345:A: Set up ifTable cache properties.
     *
     * Also for advanced users, you can set parameters for the
     * cache. Do not change the magic pointer, as it is used
     * by the MFD helper. To completely disable caching, set
     * cache->enabled to 0.
     */
    cache->timeout = IFTABLE_CACHE_TIMEOUT;     /* seconds */
}                               /* ifTable_container_init */

/**
 * container shutdown
 *
 * @param container_ptr A pointer to the container.
 *
 *  This function is called at shutdown to allow you to customize certain
 *  aspects of the access method. For the most part, it is for advanced
 *  users. The default code should suffice for most cases.
 *
 *  This function is called before ifTable_container_free().
 *
 * @remark
 *  This would also be a good place to do any cleanup needed
 *  for you data source. For example, closing a connection to another
 *  process that supplied the data, closing a database, etc.
 */
void
ifTable_container_shutdown(netsnmp_container * container_ptr)
{
    DEBUGMSGTL(("verbose:ifTable:ifTable_container_shutdown", "called\n"));

    if (NULL == container_ptr) {
        snmp_log(LOG_ERR, "bad params to ifTable_container_shutdown\n");
        return;
    }

}                               /* ifTable_container_shutdown */

/**
 * load initial data
 *
 * TODO:350:M: Implement ifTable data load
 * This function will also be called by the cache helper to load
 * the container again (after the container free function has been
 * called to free the previous contents).
 *
 * @param container container to which items should be inserted
 *
 * @retval MFD_SUCCESS              : success.
 * @retval MFD_RESOURCE_UNAVAILABLE : Can't access data source
 * @retval MFD_ERROR                : other error.
 *
 *  This function is called to load the index(es) (and data, optionally)
 *  for the every row in the data set.
 *
 * @remark
 *  While loading the data, the only important thing is the indexes.
 *  If access to your data is cheap/fast (e.g. you have a pointer to a
 *  structure in memory), it would make sense to update the data here.
 *  If, however, the accessing the data invovles more work (e.g. parsing
 *  some other existing data, or peforming calculations to derive the data),
 *  then you can limit yourself to setting the indexes and saving any
 *  information you will need later. Then use the saved information in
 *  ifTable_row_prep() for populating data.
 *
 * @note
 *  If you need consistency between rows (like you want statistics
 *  for each row to be from the same time frame), you should set all
 *  data here.
 *
 */
int
ifTable_container_load(netsnmp_container * container)
{
    ifTable_rowreq_ctx *rowreq_ctx;
    size_t          count = 0;

    /*
     * temporary storage for index values
     */
    /*
     * ifIndex(1)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/w/e/R/d/H
     */
    long            ifIndex;


    /*
     * this example code is based on a data source that is a
     * text file to be read and parsed.
     */
    FILE           *filep;
    char            line[MAX_LINE_SIZE];

    DEBUGMSGTL(("verbose:ifTable:ifTable_container_load", "called\n"));

    /*
     ***************************************************
     ***             START EXAMPLE CODE              ***
     ***---------------------------------------------***/
    /*
     * open our data file.
     */
    filep = fopen("/etc/dummy.conf", "r");
    if (NULL == filep) {
        return MFD_RESOURCE_UNAVAILABLE;
    }

    /*
     ***---------------------------------------------***
     ***              END  EXAMPLE CODE              ***
     ***************************************************/
    /*
     * TODO:351:M: |-> Load/update data in the ifTable container.
     * loop over your ifTable data, allocate a rowreq context,
     * set the index(es) [and data, optionally] and insert into
     * the container.
     */
    while (1) {
        /*
         ***************************************************
         ***             START EXAMPLE CODE              ***
         ***---------------------------------------------***/
        /*
         * get a line (skip blank lines)
         */
        do {
            if (!fgets(line, sizeof(line), filep)) {
                /*
                 * we're done 
                 */
                fclose(filep);
                filep = NULL;
            }
        } while (filep && (line[0] == '\n'));

        /*
         * check for end of data
         */
        if (NULL == filep)
            break;

        /*
         * parse line into variables
         */
        /*
         ***---------------------------------------------***
         ***              END  EXAMPLE CODE              ***
         ***************************************************/

        /*
         * TODO:352:M: |   |-> set indexes in new ifTable rowreq context.
         * data context will be set from the param (unless NULL,
         *      in which case a new data context will be allocated)
         */
        rowreq_ctx = ifTable_allocate_rowreq_ctx(NULL);
        if (NULL == rowreq_ctx) {
            snmp_log(LOG_ERR, "memory allocation failed\n");
            return MFD_RESOURCE_UNAVAILABLE;
        }
        if (MFD_SUCCESS != ifTable_indexes_set(rowreq_ctx, ifIndex)) {
            snmp_log(LOG_ERR, "error setting index while loading "
                     "ifTable data.\n");
            ifTable_release_rowreq_ctx(rowreq_ctx);
            continue;
        }

        /*
         * TODO:352:r: |   |-> populate ifTable data context.
         * Populate data context here. (optionally, delay until row prep)
         */
        /*
         * TRANSIENT or semi-TRANSIENT data:
         * copy data or save any info needed to do it in row_prep.
         */
        /*
         * setup/save data for ifDescr
         * ifDescr(2)/DisplayString/ASN_OCTET_STR/char(char)//L/A/w/e/R/d/H
         */
        /*
         * TODO:246:r: |-> Define ifDescr mapping.
         * Map values between raw/native values and MIB values
         *
         * if(MFD_SUCCESS !=
         *    ifDescr_map(&rowreq_ctx->data.ifDescr, &rowreq_ctx->data.ifDescr_len,
         *                ifDescr, ifDescr_len, 0)) {
         *    return MFD_ERROR;
         * }
         */
        /*
         * make sure there is enough space for ifDescr data
         */
        if ((NULL == rowreq_ctx->data.ifDescr) ||
            (rowreq_ctx->data.ifDescr_len <
             (ifDescr_len * sizeof(ifDescr[0])))) {
            snmp_log(LOG_ERR, "not enough space for value\n");
            return MFD_ERROR;
        }
        rowreq_ctx->data.ifDescr_len = ifDescr_len * sizeof(ifDescr[0]);
        memcpy(rowreq_ctx->data.ifDescr, ifDescr,
               ifDescr_len * sizeof(ifDescr[0]));

        /*
         * setup/save data for ifType
         * ifType(3)/IANAifType/ASN_INTEGER/long(u_long)//l/A/w/E/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifType mapping.
         * Map values between raw/native values and MIB values
         *
         * enums usually need mapping.
         */
        if (MFD_SUCCESS != ifType_map(&rowreq_ctx->data.ifType, ifType)) {
            return MFD_ERROR;
        }

        /*
         * setup/save data for ifMtu
         * ifMtu(4)/INTEGER32/ASN_INTEGER/long(long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifMtu mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifMtu = ifMtu;

        /*
         * setup/save data for ifSpeed
         * ifSpeed(5)/GAUGE/ASN_GAUGE/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifSpeed mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifSpeed = ifSpeed;

        /*
         * setup/save data for ifPhysAddress
         * ifPhysAddress(6)/PhysAddress/ASN_OCTET_STR/char(char)//L/A/w/e/r/d/H
         */
        /*
         * TODO:246:r: |-> Define ifPhysAddress mapping.
         * Map values between raw/native values and MIB values
         *
         * if(MFD_SUCCESS !=
         *    ifPhysAddress_map(&rowreq_ctx->data.ifPhysAddress, &rowreq_ctx->data.ifPhysAddress_len,
         *                ifPhysAddress, ifPhysAddress_len, 0)) {
         *    return MFD_ERROR;
         * }
         */
        /*
         * make sure there is enough space for ifPhysAddress data
         */
        if ((NULL == rowreq_ctx->data.ifPhysAddress) ||
            (rowreq_ctx->data.ifPhysAddress_len <
             (ifPhysAddress_len * sizeof(ifPhysAddress[0])))) {
            snmp_log(LOG_ERR, "not enough space for value\n");
            return MFD_ERROR;
        }
        rowreq_ctx->data.ifPhysAddress_len =
            ifPhysAddress_len * sizeof(ifPhysAddress[0]);
        memcpy(rowreq_ctx->data.ifPhysAddress, ifPhysAddress,
               ifPhysAddress_len * sizeof(ifPhysAddress[0]));

        /*
         * setup/save data for ifAdminStatus
         * ifAdminStatus(7)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifAdminStatus mapping.
         * Map values between raw/native values and MIB values
         *
         * enums usually need mapping.
         */
        if (MFD_SUCCESS !=
            ifAdminStatus_map(&rowreq_ctx->data.ifAdminStatus,
                              ifAdminStatus)) {
            return MFD_ERROR;
        }

        /*
         * setup/save data for ifOperStatus
         * ifOperStatus(8)/INTEGER/ASN_INTEGER/long(u_long)//l/A/w/E/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifOperStatus mapping.
         * Map values between raw/native values and MIB values
         *
         * enums usually need mapping.
         */
        if (MFD_SUCCESS !=
            ifOperStatus_map(&rowreq_ctx->data.ifOperStatus,
                             ifOperStatus)) {
            return MFD_ERROR;
        }

        /*
         * setup/save data for ifLastChange
         * ifLastChange(9)/TICKS/ASN_TIMETICKS/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifLastChange mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifLastChange = ifLastChange;

        /*
         * setup/save data for ifInOctets
         * ifInOctets(10)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifInOctets mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifInOctets = ifInOctets;

        /*
         * setup/save data for ifInUcastPkts
         * ifInUcastPkts(11)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifInUcastPkts mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifInUcastPkts = ifInUcastPkts;

        /*
         * setup/save data for ifInNUcastPkts
         * ifInNUcastPkts(12)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifInNUcastPkts mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifInNUcastPkts = ifInNUcastPkts;

        /*
         * setup/save data for ifInDiscards
         * ifInDiscards(13)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifInDiscards mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifInDiscards = ifInDiscards;

        /*
         * setup/save data for ifInErrors
         * ifInErrors(14)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifInErrors mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifInErrors = ifInErrors;

        /*
         * setup/save data for ifInUnknownProtos
         * ifInUnknownProtos(15)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifInUnknownProtos mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifInUnknownProtos = ifInUnknownProtos;

        /*
         * setup/save data for ifOutOctets
         * ifOutOctets(16)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifOutOctets mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifOutOctets = ifOutOctets;

        /*
         * setup/save data for ifOutUcastPkts
         * ifOutUcastPkts(17)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifOutUcastPkts mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifOutUcastPkts = ifOutUcastPkts;

        /*
         * setup/save data for ifOutNUcastPkts
         * ifOutNUcastPkts(18)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifOutNUcastPkts mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifOutNUcastPkts = ifOutNUcastPkts;

        /*
         * setup/save data for ifOutDiscards
         * ifOutDiscards(19)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifOutDiscards mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifOutDiscards = ifOutDiscards;

        /*
         * setup/save data for ifOutErrors
         * ifOutErrors(20)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifOutErrors mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifOutErrors = ifOutErrors;

        /*
         * setup/save data for ifOutQLen
         * ifOutQLen(21)/GAUGE/ASN_GAUGE/u_long(u_long)//l/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifOutQLen mapping.
         * Map values between raw/native values and MIB values
         *
         * Integer based value can usually just do a direct copy.
         */
        rowreq_ctx->data.ifOutQLen = ifOutQLen;

        /*
         * setup/save data for ifSpecific
         * ifSpecific(22)/OBJECTID/ASN_OBJECT_ID/oid(oid)//L/A/w/e/r/d/h
         */
        /*
         * TODO:246:r: |-> Define ifSpecific mapping.
         * Map values between raw/native values and MIB values
         *
         * if(MFD_SUCCESS !=
         *    ifSpecific_map(&rowreq_ctx->data.ifSpecific, &rowreq_ctx->data.ifSpecific_len,
         *                ifSpecific, ifSpecific_len, 0)) {
         *    return MFD_ERROR;
         * }
         */
        /*
         * make sure there is enough space for ifSpecific data
         */
        if ((NULL == rowreq_ctx->data.ifSpecific) ||
            (rowreq_ctx->data.ifSpecific_len <
             (ifSpecific_len * sizeof(ifSpecific[0])))) {
            snmp_log(LOG_ERR, "not enough space for value\n");
            return MFD_ERROR;
        }
        rowreq_ctx->data.ifSpecific_len =
            ifSpecific_len * sizeof(ifSpecific[0]);
        memcpy(rowreq_ctx->data.ifSpecific, ifSpecific,
               ifSpecific_len * sizeof(ifSpecific[0]));

        /*
         * setup/save data for ifOWD
         * ifOWD(23)/DisplayString/ASN_OCTET_STR/char(char)//L/A/w/e/R/d/h
         */
        /*
         * TODO:246:r: |-> Define ifOWD mapping.
         * Map values between raw/native values and MIB values
         *
         * if(MFD_SUCCESS !=
         *    ifOWD_map(&rowreq_ctx->data.ifOWD, &rowreq_ctx->data.ifOWD_len,
         *                ifOWD, ifOWD_len, 0)) {
         *    return MFD_ERROR;
         * }
         */
        /*
         * make sure there is enough space for ifOWD data
         */
        if ((NULL == rowreq_ctx->data.ifOWD) ||
            (rowreq_ctx->data.ifOWD_len <
             (ifOWD_len * sizeof(ifOWD[0])))) {
            snmp_log(LOG_ERR, "not enough space for value\n");
            return MFD_ERROR;
        }
        rowreq_ctx->data.ifOWD_len = ifOWD_len * sizeof(ifOWD[0]);
        memcpy(rowreq_ctx->data.ifOWD, ifOWD,
               ifOWD_len * sizeof(ifOWD[0]));

        /*
         * setup/save data for ifATR
         * ifATR(24)/DisplayString/ASN_OCTET_STR/char(char)//L/A/w/e/R/d/h
         */
        /*
         * TODO:246:r: |-> Define ifATR mapping.
         * Map values between raw/native values and MIB values
         *
         * if(MFD_SUCCESS !=
         *    ifATR_map(&rowreq_ctx->data.ifATR, &rowreq_ctx->data.ifATR_len,
         *                ifATR, ifATR_len, 0)) {
         *    return MFD_ERROR;
         * }
         */
        /*
         * make sure there is enough space for ifATR data
         */
        if ((NULL == rowreq_ctx->data.ifATR) ||
            (rowreq_ctx->data.ifATR_len <
             (ifATR_len * sizeof(ifATR[0])))) {
            snmp_log(LOG_ERR, "not enough space for value\n");
            return MFD_ERROR;
        }
        rowreq_ctx->data.ifATR_len = ifATR_len * sizeof(ifATR[0]);
        memcpy(rowreq_ctx->data.ifATR, ifATR,
               ifATR_len * sizeof(ifATR[0]));

        /*
         * setup/save data for ifBER
         * ifBER(25)/DisplayString/ASN_OCTET_STR/char(char)//L/A/w/e/R/d/h
         */
        /*
         * TODO:246:r: |-> Define ifBER mapping.
         * Map values between raw/native values and MIB values
         *
         * if(MFD_SUCCESS !=
         *    ifBER_map(&rowreq_ctx->data.ifBER, &rowreq_ctx->data.ifBER_len,
         *                ifBER, ifBER_len, 0)) {
         *    return MFD_ERROR;
         * }
         */
        /*
         * make sure there is enough space for ifBER data
         */
        if ((NULL == rowreq_ctx->data.ifBER) ||
            (rowreq_ctx->data.ifBER_len <
             (ifBER_len * sizeof(ifBER[0])))) {
            snmp_log(LOG_ERR, "not enough space for value\n");
            return MFD_ERROR;
        }
        rowreq_ctx->data.ifBER_len = ifBER_len * sizeof(ifBER[0]);
        memcpy(rowreq_ctx->data.ifBER, ifBER,
               ifBER_len * sizeof(ifBER[0]));


        /*
         * insert into table container
         */
        CONTAINER_INSERT(container, rowreq_ctx);
        ++count;
    }

    /*
     ***************************************************
     ***             START EXAMPLE CODE              ***
     ***---------------------------------------------***/
    if (NULL != filep)
        fclose(filep);
    /*
     ***---------------------------------------------***
     ***              END  EXAMPLE CODE              ***
     ***************************************************/

    DEBUGMSGT(("verbose:ifTable:ifTable_container_load",
               "inserted %d records\n", count));

    return MFD_SUCCESS;
}                               /* ifTable_container_load */

/**
 * container clean up
 *
 * @param container container with all current items
 *
 *  This optional callback is called prior to all
 *  item's being removed from the container. If you
 *  need to do any processing before that, do it here.
 *
 * @note
 *  The MFD helper will take care of releasing all the row contexts.
 *
 */
void
ifTable_container_free(netsnmp_container * container)
{
    DEBUGMSGTL(("verbose:ifTable:ifTable_container_free", "called\n"));

    /*
     * TODO:380:M: Free ifTable container data.
     */
}                               /* ifTable_container_free */

/**
 * prepare row for processing.
 *
 *  When the agent has located the row for a request, this function is
 *  called to prepare the row for processing. If you fully populated
 *  the data context during the index setup phase, you may not need to
 *  do anything.
 *
 * @param rowreq_ctx pointer to a context.
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 */
int
ifTable_row_prep(ifTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:ifTable:ifTable_row_prep", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:390:o: Prepare row for request.
     * If populating row data was delayed, this is the place to
     * fill in the row for this request.
     */

    return MFD_SUCCESS;
}                               /* ifTable_row_prep */

/** @} */
