#!/bin/sh
# https://sourceforge.net/projects/minidlna/
# https://github.com/sergiomb2/minidlna
# https://github.com/openbsd/ports/tree/master/multimedia/minidlna

name="minidlna";

cd /tmp
if [ ! -d minidlna ]; then
   git clone https://github.com/sergiomb2/minidlna.git;
   #git clone https://github.com/glebius/minidlna.git; # "make test" error
fi

cd minidlna/

echo -e "\n> patching...";
patch -p0 <~/src/$name/configure.ac.patch
patch -p0 <~/src/$name/kqueue.c.patch
patch -p0 <~/src/$name/upnpsoap.c.patch; # https://github.com/sergiomb2/minidlna/commit/09c21da68ce3a96bbbe859f466650a913b49be63
#patch -p0 <~/src/$name/patch-libav_h.txt; # obsolete?
patch -p0 <~/src/$name/libav.h.patch;
patch -p0 <~/src/$name/patch-minidlna_c.txt
patch -p0 <~/src/$name/patch-utils_c.txt

echo -e "\n> installing required packages...";

#- libexif
#doas pkg_add libexif;

#- libjpeg
#doas pkg_add jpeg;

#- libid3tag
#doas pkg_add libid3tag; 

#- libFLAC
#doas pkg_add flac;

#- libvorbis
#doas pkg_add libvorbis;

#- libsqlite3
#doas pkg_add sqlite3;

#- libavformat (the ffmpeg libraries)
#doas pkg_add ffmpeg;

#doas pkg_add autoconf automake m4 gmake libtool gettext-tools libiconv
#doas pkg_add ffmpegthumbnailer libogg intltool
#doas pkg_add libmp4v2; # not used

echo -e "\n> configuring...";

export AUTOCONF_VERSION="$( pkg_info | perl -nle '/autoconf-([0-9\.]+)/ and print $1' | tail -1 )";
export AUTOMAKE_VERSION="$( pkg_info | perl -nle '/automake-([0-9\.]+)/ and print $1' | tail -1 )";
echo "AUTOCONF_VERSION=$AUTOCONF_VERSION";
echo "AUTOMAKE_VERSION=$AUTOMAKE_VERSION";

export CPPFLAGS="$CPPFLAGS -I/usr/local/include -I/usr/X11R6/include"; # $( pkg-config --cflags libavutil )";
export  LDFLAGS="$LDFLAGS  -L/usr/local/lib     -L/usr/X11R6/lib"; # $( pkg-config --libs-only-L libavutil )";

make distclean >/dev/null 2>&1

./autogen.sh

echo -e "\n> configure";
./configure \
   --sysconfdir=/etc \
   --localstatedir=/var \
   --with-db-path=/var/db/minidlna \
   --with-log-path=/var/log/minidlna \
   1>configure-stdout.log \
   2>configure-stderr.log

#   --enable-thumbnail \
#   LIBFFMPEGTHUMBNAILER_CFLAGS="-I/usr/local/lib" \
#   LIBFFMPEGTHUMBNAILER_LIBS="-L/usr/local/include";

echo -e "\n> make";
make
make check

echo ""
ldd minidlnad | grep av
