/*
 * Silverscreen
 * (C) 2010 William Lahti.
 *
 */

using System;
using System.IO;
using System.Text;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Reflection;
using System.Globalization;

using Tao.OpenGl;
using Tao.DevIl;
using Tao.Platform.X11;
using GtkGL;

namespace Silverscreen {
	public static unsafe partial class SilverGL {
		const int GLX_BIND_TO_TEXTURE_RGB_EXT = 0x20D0;
		const int GLX_BIND_TO_TEXTURE_RGBA_EXT = 0x20D1;
		const int GLX_BIND_TO_MIPMAP_TEXTURE_EXT = 0x20D2;
		const int GLX_BIND_TO_TEXTURE_TARGETS_EXT = 0x20D3;
		const int GLX_Y_INVERTED_EXT = 0x20D4;
		const int GLX_TEXTURE_FORMAT_EXT = 0x20D5;
		const int GLX_TEXTURE_TARGET_EXT = 0x20D6;
		const int GLX_MIPMAP_TEXTURE_EXT = 0x20D7;
		const int GLX_TEXTURE_FORMAT_NONE_EXT = 0x20D8;
		const int GLX_TEXTURE_FORMAT_RGB_EXT = 0x20D9;
		const int GLX_TEXTURE_FORMAT_RGBA_EXT = 0x20DA;
		const int GLX_TEXTURE_1D_BIT_EXT = 0x00000001;
		const int GLX_TEXTURE_2D_BIT_EXT = 0x00000002;
		const int GLX_TEXTURE_RECTANGLE_BIT_EXT = 0x00000004;
		const int GLX_TEXTURE_1D_EXT = 0x20DB;
		const int GLX_TEXTURE_2D_EXT = 0x20DC;
		const int GLX_TEXTURE_RECTANGLE_EXT = 0x20DD;
		const int GLX_FRONT_LEFT_EXT = 0x20DE;
		const int GLX_FRONT_RIGHT_EXT = 0x20DF;
		const int GLX_BACK_LEFT_EXT = 0x20E0;
		const int GLX_BACK_RIGHT_EXT = 0x20E1;
		const int GLX_FRONT_EXT = GLX_FRONT_LEFT_EXT;
		const int GLX_BACK_EXT = GLX_BACK_LEFT_EXT;
		const int GLX_AUX0_EXT = 0x20E2;
		const int GLX_AUX1_EXT = 0x20E3;
		const int GLX_AUX2_EXT = 0x20E4;
		const int GLX_AUX3_EXT = 0x20E5;
		const int GLX_AUX4_EXT = 0x20E6;
		const int GLX_AUX5_EXT = 0x20E7;
		const int GLX_AUX6_EXT = 0x20E8;
		const int GLX_AUX7_EXT = 0x20E9;
		const int GLX_AUX8_EXT = 0x20EA;
		const int GLX_AUX9_EXT = 0x20EB;

		public static void Black ()
		{
			Gl.glColor4f(0,0,0,1);
		}
		
		public static void White ()
		{
			Gl.glColor4f(1,1,1,1);
		}

		public static void Grayscale (float f, float a)
		{
			Gl.glColor4f(f,f,f,a);
		}

		public static void Grayscale (float f)
		{
			Gl.glColor4f(f,f,f,1);
		}
		
		public static bool UserToDevice (double x, double y, out double ox, out double oy)
		{
			double[] projMatrix = new double[16];
			double[] modelMatrix = new double[16];
			int[] viewport = new int[4];
			double oz;
			
			Gl.glGetDoublev (Gl.GL_PROJECTION_MATRIX, projMatrix);
			Gl.glGetDoublev (Gl.GL_MODELVIEW_MATRIX, modelMatrix);
			Gl.glGetIntegerv (Gl.GL_VIEWPORT, viewport);
			return Glu.gluProject (x, y, 0, modelMatrix, projMatrix, viewport, out ox, out oy, out oz) == Glu.GLU_TRUE;
		}
		
		/// <summary>
		/// Find the lowest power of 2 above the given integer.
		/// </summary>
		public static int BinaryBound(int a)
		{
			int ret = 1;
			while (ret < a) ret = ret << 1;
			return ret;
		}
		
		public static void ClipScissors (int x, int y, int w, int h)
		{
			Gl.glScissor (x, y, w, h);
			Gl.glEnable (Gl.GL_SCISSOR_TEST);
		}

		public static void ClearScissors ()
		{
			Gl.glDisable (Gl.GL_SCISSOR_TEST);
		}

		public static void DrawClip ()
		{
			Gl.glClearStencil (0);
			Gl.glClear(Gl.GL_STENCIL_BUFFER_BIT);
			Gl.glEnable (Gl.GL_STENCIL_TEST);
			Gl.glStencilFunc (Gl.GL_ALWAYS, 1, 1);
			Gl.glStencilOp (Gl.GL_KEEP, Gl.GL_KEEP, Gl.GL_REPLACE);
			Gl.glColorMask (false, false, false, false);

			CheckGL();
		}

		public static void ApplyClip ()
		{
			Gl.glColorMask (true, true, true, true);
			Gl.glStencilFunc (Gl.GL_EQUAL, 1, 1);
			Gl.glStencilOp (Gl.GL_KEEP, Gl.GL_KEEP, Gl.GL_KEEP);

			CheckGL();
		}
		
		public static void ApplyClipInvert ()
		{
			Gl.glColorMask (true, true, true, true);
			Gl.glStencilFunc (Gl.GL_EQUAL, 0, 1);
			Gl.glStencilOp (Gl.GL_KEEP, Gl.GL_KEEP, Gl.GL_KEEP);
			
			CheckGL();
		}

		public static void CheckGL ()
		{
			#if false //DEBUG
			
			int err = Gl.glGetError();

			if (err == Gl.GL_NO_ERROR)
				return;

			Console.Error.WriteLine ("GL error #{0}", err);

			if (err == Gl.GL_INVALID_ENUM)
				throw new Exception ("OpenGL: Invalid Enumeration");
			if (err == Gl.GL_INVALID_VALUE)
				throw new Exception ("OpenGL: Invalid Value");
			if (err == Gl.GL_INVALID_OPERATION)
				throw new Exception ("OpenGL: Invalid Operation");
			if (err == Gl.GL_STACK_OVERFLOW)
				throw new Exception ("OpenGL: Stack Overflow");
			if (err == Gl.GL_STACK_UNDERFLOW)
				throw new Exception ("OpenGL: Stack Underflow");
			if (err == Gl.GL_OUT_OF_MEMORY)
				throw new Exception ("OpenGL: Out of memory");
			if (err == Gl.GL_TABLE_TOO_LARGE)
				throw new Exception ("OpenGL: Table too large");

			#endif
		}
		
		public static void ClearClip ()
		{
			Gl.glDisable(Gl.GL_STENCIL_TEST);
		}

		public static void Quad (float x, float y, float w, float h, bool tex)
		{
			Gl.glBegin(Gl.GL_TRIANGLE_STRIP);
				if (tex) Gl.glTexCoord2f(0.0f,1.0f); Gl.glVertex2f(x, y);
				if (tex) Gl.glTexCoord2f(1.0f,1.0f); Gl.glVertex2f(x + w, y);
				if (tex) Gl.glTexCoord2f(0.0f,0.0f); Gl.glVertex2f(x, y + h);
				if (tex) Gl.glTexCoord2f(1.0f,0.0f); Gl.glVertex2f(x + w, y + h);
			Gl.glEnd();

			CheckGL();
		}


		public static void QuadLines (float x, float y, float w, float h)
		{
			QuadLines (x, y, w, h, 2);
			CheckGL();
		}
		
		public static void QuadLines (float x, float y, float w, float h, float width)
		{
			Gl.glLineWidth (width);
			Gl.glBegin(Gl.GL_LINE_LOOP);
				Gl.glVertex2f(x, y);
				Gl.glVertex2f(x + w, y);
				Gl.glVertex2f(x + w, y + h);
				Gl.glVertex2f(x, y + h);
			Gl.glEnd();
			CheckGL();
		}
	}
}