/*
 * Silverscreen
 * (C) 2010 William Lahti.
 *
 */

using System;
using System.IO;
using System.Threading;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using System.Reflection;
using System.Globalization;
using System.Collections.Generic;

using Tao.OpenGl;
using Tao.DevIl;
using Tao.Sdl;
using GtkGL;

namespace Silverscreen {
	public static class GstGLBufferExtensions {
		public static int GLGetWidth (this Gst.Buffer buf)
		{
			return Glue.ss_gst_gl_buffer_get_width (buf.Handle);
		}
		public static int GLGetHeight (this Gst.Buffer buf)
		{
			return Glue.ss_gst_gl_buffer_get_height (buf.Handle);
		}
		public static uint GLGetTexture (this Gst.Buffer buf)
		{
			return Glue.ss_gst_gl_buffer_get_texture (buf.Handle);
		}
		
		public static void GLSetWidth (this Gst.Buffer buf, int w)
		{
			Glue.ss_gst_gl_buffer_set_width (buf.Handle, w);
		}
		public static void GLSetHeight (this Gst.Buffer buf, int h)
		{
			Glue.ss_gst_gl_buffer_set_width (buf.Handle, h);
		}
		
		public static void GLSetTexture (this Gst.Buffer buf, uint t)
		{
			Glue.ss_gst_gl_buffer_set_texture (buf.Handle, t);
		}
		
		public static IntPtr GLGetDisplay (this Gst.Buffer buf)
		{
			return Glue.ss_gst_gl_buffer_get_display (buf.Handle);
		}
	}
}