/*
 * Silverscreen
 * (C) 2010 William Lahti.
 *
 */

using System;
using System.IO;
using System.Threading;
using System.Runtime.InteropServices;
using System.Reflection;
using System.Globalization;
using System.Collections.Generic;

using Tao.OpenGl;
using Tao.DevIl;
using Tao.Sdl;
using GtkGL;

namespace Silverscreen {
	public static class GstExtensions {
		public static Gst.Element GetElement (this Gst.Bin bin, string name)
		{
			foreach (Gst.Element e in bin.Elements)
				if (e.Name == name)
					return e;

			return null;
		}

		public static void Reset (this Gst.Bin bin)
		{
			bin.SetState (Gst.State.Null);
		}
		public static void Play (this Gst.Bin bin)
		{
			bin.SetState (Gst.State.Playing);
		}
		public static void Pause (this Gst.Bin bin)
		{
			bin.SetState (Gst.State.Paused);
		}

	}
}