/*
 * Simple test using OpenGL and shaders. Intended to be used as
 * template for quick OpenGL tests.
 *
 * Author: Alejandro Piñeiro Iglesias <apinheiro@igalia.com>
 *
 */

#include <stdio.h>
#include <string.h>

#define GL_GLEXT_PROTOTYPES

#include <GL/gl.h>
#include <GL/glext.h>
#include <GL/glu.h>
#include <GL/glut.h>

#include "aux-GLSL.h"

#define WINDOW_WIDTH    640
#define WINDOW_HEIGHT   480

#define RED_BINDING_POINT 3
#define GREEN_BINDING_POINT 6

int window;
ProgramNode *program_node;
GLuint program;
GLuint red_buffer;
GLuint green_buffer;

GLuint red_initial_value = 0;
GLuint green_initial_value = 0;


void
on_key_press (unsigned char key,
              int x, int y)
{
  glutDestroyWindow (window);
  exit (0);
}

static void
create_atomics_buffer ()
{
  GLuint red_data[1] = {red_initial_value};
  GLuint green_data[1] = {green_initial_value};

  glGenBuffers (1, &red_buffer);
  glBindBuffer (GL_ATOMIC_COUNTER_BUFFER, red_buffer);
  glBufferData (GL_ATOMIC_COUNTER_BUFFER, sizeof(GLuint),
                red_data, GL_DYNAMIC_DRAW);
  glBindBufferBase (GL_ATOMIC_COUNTER_BUFFER, RED_BINDING_POINT, red_buffer);

  glGenBuffers (1, &green_buffer);
  glBindBuffer (GL_ATOMIC_COUNTER_BUFFER, green_buffer);
  glBufferData (GL_ATOMIC_COUNTER_BUFFER, sizeof(GLuint),
                green_data, GL_DYNAMIC_DRAW);
  glBindBufferBase (GL_ATOMIC_COUNTER_BUFFER, GREEN_BINDING_POINT, green_buffer);
}

static void
read_atomics_buffer ()
{
  GLuint red_data[1];
  GLuint green_data[1];

  glBindBuffer (GL_ATOMIC_COUNTER_BUFFER, red_buffer);
  glGetBufferSubData(GL_ATOMIC_COUNTER_BUFFER, 0, sizeof(GLuint),
                     red_data);

  glBindBuffer (GL_ATOMIC_COUNTER_BUFFER, green_buffer);
  glGetBufferSubData(GL_ATOMIC_COUNTER_BUFFER, 0, sizeof(GLuint),
                     green_data);

  printf ("Current red counter value = %i, current green counter value = %i\n",
          red_data[0], green_data[0]);
}

void
scene_render (void)
{
  glClearColor (0.0, 0.0, 0.0, 1.0);
  glClear (GL_COLOR_BUFFER_BIT);
  glPointSize (10.0);

  glUseProgram (program);

  printf ("Before drawing\n");
  read_atomics_buffer();

  /* We expect this point to be slightly on the right */
  glBegin (GL_POINTS);
  glVertex2f (0.0, 0.0);
  glEnd();

  glFlush(); /* Needed if you want to have an accurate value of the atomic */

  printf ("After drawing\n");
  read_atomics_buffer();

  glutSwapBuffers();
}

static void
setup ()
{
  int result = 0;

  result = aux_create_program ("simple.vert", "simple.frag", &program_node);
  if (!result)
    fprintf (stderr, "Failed to compile the program!");

  program = program_node->program_object;

  /* TODO: here is a good place to set the uniform parameters */

  create_atomics_buffer ();
}

int
main(int argc,
     char *argv[])
{
  if (argc < 3) {
    printf ("Wrong number of parameters. Usage: simple-opengl-test red_counter green_counter\n");
    return 0;
  }

  red_initial_value = atoi(argv[1]);
  green_initial_value = atoi(argv[2]);

  glutInit (&argc, argv);
  glutInitDisplayMode (GLUT_RGBA | GLUT_DOUBLE);
  glutInitWindowSize (WINDOW_WIDTH, WINDOW_HEIGHT);

  window = glutCreateWindow (argv[0]);

  glutDisplayFunc (scene_render);
  glutKeyboardFunc (on_key_press);

  printf ("GL_VERSION = %s\n", (char *) glGetString (GL_VERSION));
  printf ("GL_GL_MAX_VERTEX_ATOMIC_COUNTERS = %i\n",
          GL_MAX_VERTEX_ATOMIC_COUNTERS);

  setup ();

  glutMainLoop();

  /* FIXME: cleaning is needed */

  return 0;
}
