/* ========================================================================= *
 * File: fpumodetest.cpp
 *
 * Copyright (C) 2010 Nokia Corporation. All rights reserved.
 *
 * Contacts: Leonid Moiseichuk <leonid.moiseichuk@nokia.com>
 *
 *  Testing module for fpumode preload library for scalars/vectors.
 *  Done in C++ due to Qt is selected as MeeGo base library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

/* ========================================================================= *
 * Includes
 * ========================================================================= */

#include <sys/time.h>
#include <time.h>
#include <stdio.h>


/* function which simulates scalar load */
template <class T>
T scalar_load(void)
{
    T a = 1;
    T b = 2;
    T c = 1.0 * time(NULL);
    int   i;
    for (i = 0; i < 500 * 1000 * 1000; i++)
    {
      a += c;
      b -= c;
      c = a * b;
      c /= 123;
    }
    return c;
} /* scalar_load */

/* function which simulates vector load */
template <class T>
T vector_load(void)
{
  static const T v[4][4] =
  {
    { 1, 2, 3, 4 },
    { 5, 6, 7, 8 },
    { 1, 6, 3, 8 },
    { 5, 2, 7, 4 },
  };
  T c = 1.0 * time(NULL);
  int   i;
  int   a = 0;
  int   b = 1;
  for (i = 0; i < 100 * 1000 * 1000; i++)
  {
    c += v[a][0] * v[b][0] + v[a][1] * v[b][1] + v[a][2] * v[b][2] + v[a][3] * v[b][3];
    a = (a + 1) & 0x03;
    b = (b + 1) & 0x03;
  }
  return c;
} /* vector_load */


#define TEST_CALL(wh,tp,result)                             \
            {                                               \
              printf ("* run %s<%s> testing\n", #wh, #tp);  \
              struct timeval t0;                            \
              struct timeval t1;                            \
              gettimeofday(&t0, NULL);                      \
              result += wh<tp>();                           \
              gettimeofday(&t1, NULL);                      \
              printf ("=> %u.%06u seconds\n", (t1.tv_sec - t0.tv_sec), (t1.tv_usec - t0.tv_usec));  \
            }


int main(const int argc, const char* argv[])
{
  float result = 0; /* result is necessary to prevent optimizations by smart compilers */

  TEST_CALL(scalar_load, float,  result);
  TEST_CALL(vector_load, float,  result);
  TEST_CALL(scalar_load, double, result);
  TEST_CALL(vector_load, double, result);

  /* That is all */
  return (result < 0 ? -1 : (result > 0 ? 1 : 0));
} /* main */


