/*
 * banjodecoder.h
 * USL, Inc.
 *
 * Driver definitions for the banjodecoder driver.
 *
 * Revision 0.1 07/18/2007 dcogley
 * 	- Initial Creation
 *
 */

#include <linux/cdev.h>

#define BANJO_MAJOR 0	// dynamic
#define BANJO_DEVS	1

// Interrupts
#define FRAME_READY_IRQ		49
#define	DMA_STATUS_IRQ		16

// DMA buffer locations (physical)
#define DMABASE				0x0F800000
#define DMABUFFERSIZE		0x00200000
#define DMABLOCKSIZE		0x00600000
#define DMATRANSFERCOUNT	(DMABUFFERSIZE >> 2)
#define DMABUF0				(DMABASE + 0)
#define DMABUF1				(DMABUF0 + DMABUFFERSIZE)
#define DMABUF2				(DMABUF1 + DMABUFFERSIZE)
#define DMABUF3				(DMABUF2 + DMABUFFERSIZE)
#define DMABUFCOUNT			4

#define DMA0_TC_REACHED		0x80000000
#define DMA0_EOT_REQ		0x08000000
#define DMA0_ERROR			0x00800000
#define DMA0_INTERNEL_REQ	0x00080000
#define DMA0_EXTERNAL_REQ	0x00008000
#define DMA0_CHANNEL_BUSY	0x00000800
#define DMA0_SG_IN_PROGRESS	0x00000080

#define EOTN_DRIVE_HIGH		0x00008000

#define DMA_CONFIG0			0x45e001f0
#define DMA_CONTROLTC0		(0x38C00000 | DMATRANSFERCOUNT)

// FPGA register memory locations
#define BANJO_DECODER_BASE	0xc0000000
#define BANJO_MEDIA_ADDR	0x0000
#define BANJO_STATUS_ADDR	0x1030
#define BANJO_RESET_ADDR	0x1104
#define BANJO_REGISTERMAP_SIZE	0xffff

#define BANJO_RESET_DELAY	500		// ms

// DMA register locations
#define DMA2P40_CR0			0x300
#define DMA2P40_CTC0		0x301
#define DMA2P40_SAH0		0x302
#define DMA2P40_SAL0		0x303
#define DMA2P40_DAH0		0x304
#define DMA2P40_DAL0		0x305
#define DMA2P40_SR			0x320

#define DMA_ENABLE_CHANNEL	0x80000000

/*-----------------------------------------------------------------------------
 | External Bus Controller
 +----------------------------------------------------------------------------*/
#define EBC_DCR_BASE 		0x12
#define ebccfga 			(EBC_DCR_BASE+0x0)  /* External bus controller addr reg     */
#define ebccfgd 			(EBC_DCR_BASE+0x1)  /* External bus controller data reg     */

#define PB1CR				0x01			/* periph bank 1 configuration	*/
#define PB1AP				0x11			/* periph bank 1 access parameters	*/
#define PB1AP_ENABLE		0x00040300
#define GPIO1_OR			0xef600C00		// GPIO1 output register

// banjo internal DMA structures
#define BANJO_DMA_SIZE			0x00FFFFFF	// byte count mask
#define BANJO_DMA_FLAG_DMAREADY	0x80000000	// buffer is ready for DMA xfer
											// DMA is waiting for xfer request
											// from FPGA
struct banjo_dma
{
	// flags holding state and current position in buffers
	u32 flags;

	// memory location of this DMA buffer
	u32 base;
};

struct banjo_dev 
{
	struct cdev cdev;	// char device struct

	// information structures for the DMA buffers
	struct banjo_dma dma[DMABUFCOUNT];
};

extern struct banjo_dev* banjo_device;
extern struct file_operations banjo_fops;

/*
 * configurable parameters
 */
extern int banjo_major;

#include "banjoioc.h"
