/*
 * sig_exec.c: race a killing signal against exec().
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright (C) IBM Corporation, 2005
 *
 * Author: Paul E. McKenney <paulmck@us.ibm.com>
 */

#include "steamroller.h"

struct sig_test_ctrl {
	int execdone;  /* This must be first!!!! */
	int startflag;
	int raced;
};

char cmd[40] = "./sig_exec_target";
char cmd_offset[10] = "0";

int test_sig_dfl__exec(void *p, int parentspin, long childcpuset)
{
	char *args[] = { cmd, NULL };
	int i;
	int mypid = getpid();
	int pid;
	int retval;
	int status;
	struct sig_test_ctrl *stp = (struct sig_test_ctrl *)p;

	stp->execdone = 33;
	stp->startflag = 0;
	stp->raced = 0;
	if ((pid = fork()) == 0) {
		sched_setaffinity(0, sizeof(childcpuset), &childcpuset);
		stp->startflag = 1;
		spindelay(us2spindelay(100));
		stp->raced = 1;
		if (execv(cmd, args) == -1) {
			fprintf(stderr, "execl error %d\n", errno);
			perror("execl");
			exit(-1);
		}
	}
	if (pid == -1) {
		perror("fork");
		exit(-1);
	}
	if (getpid() != mypid) {
		fprintf(stderr, "process morphed! was %d, now %d\n",
				mypid, getpid());
	}
	if (pid == getpid()) {
		fprintf(stderr, "how did I fork() myself???");
	}
	while (stp->startflag == 0) continue;
	spindelay(parentspin);
	if (kill(pid, SIGINT) != 0) {
		perror("kill");
		exit(-1);
	}
	if (!stp->raced) {
		retval = STEAMROLLER_EARLY;
	} else if (stp->execdone != 1) {
		retval = STEAMROLLER_RACED;
	} else {
		retval = STEAMROLLER_LATE;
	}
	wait(&status);
	if (WIFEXITED(status)) {
		retval = STEAMROLLER_LATE;
	}
	return retval;
}

int main(int argc, char *argv[])
{
	long childcpuset;
	void *p;

	childcpuset = steamroller_init(argc, argv);
	p = (int *)mapmem(sizeof(struct sig_test_ctrl), -1);
	search_and_steamroller(test_sig_dfl__exec, p, childcpuset);
}
