#
#	Project Makefile rules.
#	Created 11-APR-2004	Richard B. Johnson
#
VRS	:= $(shell uname -r)
#
#  Substitute any kernel version for which you have a tree in
#  /usr/src, i.e., VRS=2.4.26 if you are cross-compiling.
#

INCL	= -I.

CX = gcc -Wall -Wunused $(INCL) -O4 -fomit-frame-pointer -fno-strict-aliasing -Werror -pipe
CC = $(CX) -fno-builtin -fexpensive-optimizations

%.os:%.c		
		$(CC) -shared -c -o $@ $<
		strip -x -R .note -R .comment $@ 

%.o:%.c		
		$(CC) -c -o $@ $<
		strip -x -R .note -R .comment $@ 

%.o:%.s
		as -o $@ $<

%.o:%.S
		as -o $@ $<

