#include "xmlutil.h"

int simple_isupper(int c)
{
	return (c >= 'A' && c <= 'Z');
}

int simple_islower(int c)
{
	return (c >= 'a' && c <= 'z');
}

int simple_isalpha(int c)
{
	return (simple_isupper(c) || simple_islower(c));
}

int simple_isdigit(int c)
{
	return (c >= '0' && c <= '9');
}

int simple_isdigit_string(const char *s)
{
	while (*s) {
		if (!simple_isdigit(*s))
			return 0;
		s++;
	}
	return 1;
}

int simple_isspace(int c)
{
	switch (c) {
	case ' ':
	case '\f':
	case '\n':
	case '\r':
	case '\t':
	case '\v':
		return 1;
	}
	return 0;
}

int simple_tolower(int c)
{
	if (!simple_isupper(c))
		return c;
	return (c - 'A' + 'a');
}

int simple_toupper(int c)
{
	if (!simple_islower(c))
		return c;
	return (c - 'a' + 'A');
}

int simple_isxdigit(int c)
{
	if (simple_isdigit(c))
		return 1;
	if (c >= 'A' && c <= 'F')
		return 1;
	if (c >= 'a' && c <= 'f')
		return 1;
	return 0;
}

int simple_strcasecmp(const char *s1, const char *s2)
{
	unsigned char *c1, *c2;

	c1 = (unsigned char *)s1;
	c2 = (unsigned char *)s2;
	while (*c1 && *c2 &&
	       simple_tolower(*c1) == simple_tolower(*c2)) {
		c1++;
		c2++;
	}

	return *c1 - *c2;
}

int simple_strncasecmp(const char *s1, const char *s2, size_t n)
{
	unsigned char *c1, *c2;

	if (n <= 0)
		return 0;
	c1 = (unsigned char *)s1;
	c2 = (unsigned char *)s2;
	while (*c1 && *c2 &&
	       simple_tolower(*c1) == simple_tolower(*c2)) {
		n--;
		if (n <= 0)
			return 0;
		c1++;
		c2++;
	}

	return *c1 - *c2;
}
