/***************************************************************************
 *                                                                         *
 *  Simple XML Parser.                                                     *
 *     copyright (C)  Tim Hockin <thockin@hockin.org>                      *
 *                                                                         *
 *  Heavily modified by                                                    *
 *     copyright (C) 2004, 2005  Michael Buesch <mbuesch@freenet.de>       *
 *                                                                         *
 * Released under the LGPL version 2.1 (http://www.gnu.org)                *
 * This program is free software; you can redistribute it and/or modify    *
 * it under the terms of the GNU Lesser General Public License version 2.1 *
 * as published by the Free Software Foundation.                           *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_DUMP_XMLPARSER_H_
#define PWMANAGER_DUMP_XMLPARSER_H_

#include <stddef.h>


struct xml_string
{
	char *s;
	size_t size;
	/* internal: */
	size_t _capacity;
};

struct xml_prop
{
	struct xml_string *name;
	struct xml_string *value;

	struct xml_prop *next;
	struct xml_prop *prev;
};

struct xml_element
{
	struct xml_string *name;
	struct xml_string *content;

	struct xml_prop *first_prop;
	struct xml_prop *last_prop;

	struct xml_element *first_child;
	struct xml_element *last_child;
	struct xml_element *parent;
	struct xml_element *next;
	struct xml_element *prev;
	char pr_name[128];
	int m_h_value;
	int m_h_cnt;
	int prior;
};

struct xml_buffer{
	char *text;
	size_t text_size;
};

int xml_parse_buffer(struct xml_buffer buffer, struct xml_element **ret);
void xml_free_element(struct xml_element *e);

struct xml_element* get_first_child(struct xml_element *parent);
struct xml_element* get_next_node(struct xml_element *element);
char * get_element_name(struct xml_element *element);
char * get_element_content(struct xml_element *element);
struct xml_prop *get_next_attribute( struct xml_element *element, struct xml_prop* attribute);
char *get_attribute_name(struct xml_prop* attribute);
char *get_attribute_value(struct xml_prop* attribute);
struct xml_element *get_element_parent(struct xml_element *element);
struct xml_buffer  load_xml_file(char *source);

#endif /* PWMANAGER_DUMP_XMLPARSER_H_ */ 
