/**************************************************************************************
*										      *
*	auto_conf.c:  Framework for autogeneration a Kernel Configuration	      * 
*									   	      *
*	This project was done in the Niederrhein University of Applied Sciences	      *  
*  										      *
*	Copyright (C) 2005  Ahmad Reza Cheraghi  <a_r_cheraghi@yahoo.com>   	      *
*	This is free software, see GNU General Public License 2 for details.	      *
*										      *
*										      *
*	This Framework autogenerate a Configuration based on the given rules	      *	
*	It does not guaranty that a Kernel can work after this generation since	      *
*	it is in his test-stage.						      *
*										      *
*										      *
*	Report errors, bugs, additions, wishes and comments to me:		      * 	
*	<a_r_cheraghi@yahoo.com>						      *
*										      *
*	For futher information please refer to the README.txt			      *
*  										      *
*    										      *
**************************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>

#include "xmlparser.h"

static struct xml_element *ret;
signed char answerbuf[128];  
int error_flag = 0;  

static int reading_xml_tree(struct xml_element* element, const char * option);

enum {
	read_tree,
	check_tree
} tree_mode = read_tree;



/************************************************************************
 * 			exec_rule()					*
 * 									*
 * 	calls a child process, that redirect stout to the pipe		*
 * 	and execute the rule-script throught the Unix Process		*
 * 	system().							*
 * 	The parent reads from the pipe, and copied in the variable	*
 * 	answer.								*
 ***********************************************************************/

static int exec_rule(const char* rule)
{
	int pd[2];
	pid_t childpid;
	char directory[128];
	
 	/* 
	 * reading the dirctory where the rules are 
	 */
	strncpy(directory,"scripts/kconfig/rules/", 128);
	
	strcat(directory, rule);    
	
	pipe(pd);
	
	if (( childpid = fork() ) == 0) { 
		dup2(pd[1], STDOUT_FILENO);

		close(pd[0]);		     
		close(pd[1]);		  
	 	 /* 
		  *  calling the rule 
		  */ 
		system(directory);
		exit(0);
	}
	/*
	 *  waiting for the child process to complete
	 */  
	 while ( wait ((int *) 0) != childpid)
			 continue; 		
	close(pd[1]);
	/* 
	 * reading from the pipe, that is the answer from the rule
	 */
	read( pd[0], answerbuf, 128 );
	close(pd[0]);
	return 0;
}


/************************************************************************
* 			get_rule()					*
* 									*
* 	compares the option from the rules_list with the actual 	*
* 	option, if they are the same, the rule that is containing	*
* 	int the list will be read and give to the function exec_rule	*
* 									*		
* 	After that, it will be checked if the answer is positive and it	*
* 	so and if the menu has a priority for arising the must_have	*
* 	counter.							*
* 									*
***********************************************************************/

static int get_rule (struct xml_element* child, const char * option)
{
	struct xml_prop *attribute;
	char content[128];
	attribute = NULL;
	
	attribute = get_next_attribute(child, attribute);
	
	if (attribute==NULL) {
		return 0;
	}	
	
	if (strcmp(get_attribute_name(attribute),"name") != 0) {
		printf("error in rules_list by Tag <option>\n");
		exit(1);
	}	
	/*
	* comparing actual option with attribute
	*/
	if (( strcmp(get_attribute_value(attribute),option)) != 0) {
		return 0;
	}
	
	/*
	* reading in the rule(script-)-namei from list
	*/
	strcpy(content, get_element_content(child));
	/*
	* executing the script
	*/
	exec_rule(content);
	if (child->parent->prior == 1) { 
		/*
		* if answer is positive
		*/
		if(answerbuf[0] == 'y' && answerbuf[1] == '\n') {
			/* 
			* then arise the must_have
			* counter
			*/
			child->parent->m_h_cnt++;
		}
	}
	return 0;	
}


/************************************************************************
*      			init_must_have()				*
* 									*
* 	if there is any must_have attribute in the <menu> tag 		*
* 	it will be initialised, here.					*
* 									*
***********************************************************************/



static int init_must_have(struct xml_element* child){

	struct xml_prop *attribute;	
	attribute = NULL;
	while ( (attribute = get_next_attribute(child, attribute))) {
		if (strcmp(get_attribute_name(attribute),"must_have") == 0) {
			if ( child->prior != 1) { 
				child->prior = 1;
				if (attribute->prev) {
					strncpy(child->pr_name,
					get_attribute_value(attribute->prev)
					,128);
				} else {
					printf("error in"
						"rules_list by Tag <menu>\n");
					exit(1);
				}
				child->m_h_value = 
					atoi(get_attribute_value(attribute));
				child->m_h_cnt = 0;
			}
		}
	}
	return 0;				
}


/************************************************************************
*      			reading_xml_tag()				*
* 									*
* 	This function reads the needed xml tags, they are the <option>	*
* 	and <menu> tag.						 	*
* 									*
***********************************************************************/


static int reading_xml_tag(struct xml_element* child,  const char * option)
{
	switch (tree_mode) {
	case read_tree:
		if (strcmp(get_element_name(child), "menu") == 0) {
			init_must_have(child);
		} else if ((strcmp(get_element_name(child), "option")) == 0) {
			get_rule(child, option);
		}	
		break;
		
	case check_tree:
		if (strcmp(get_element_name(child), "menu") == 0) {
			if (child->prior==0) {
				return 0;
			}
			if ((child->m_h_cnt) < (child->m_h_value) ) {
				error_flag = 1;
				printf("\n\n*********************error**"
					"*******************\n");
				printf("from %i needed options are %i" 
					" choosen in menu \" %s \"\n"
				, child->m_h_value,child->m_h_cnt,
				child->pr_name);
			}	
		}
		break;
	}
	return 0;
}


/************************************************************************
*      			reading_xml_tree()				*
* 									*
* 	the xml list is copied in struct variable, which conist of	* 
* 	childs and nodes.						*
* 	The reading of this variable will be done by recursive		*
* 	 calling the raeding_xml_tree()					*
* 									*
***********************************************************************/


int
reading_xml_tree(struct xml_element* element,  const char * option)
{
	struct xml_element *child;	
	child = NULL;
	/*
	 * Asking for a child
	 */
	if((child = get_first_child(element))) {
		reading_xml_tag(child, option);
		reading_xml_tree(child, option);
	}

	if( (child = get_next_node(element)) ) {
		reading_xml_tag(child, option);
		reading_xml_tree(child, option);
	}
	return 0;
}


int
auto_conf(char *option,  char answer[128])
{
	static int flag = 0;
	struct xml_buffer buffer;
	tree_mode = read_tree;
	answerbuf[0] = '\n';
	answerbuf[1] = 0;
	answerbuf[2] = 0;

	if (flag == 0) {
		buffer = load_xml_file("scripts/kconfig/rules/rules_list.xml");
		if ( xml_parse_buffer(buffer, &ret) ) {
			printf("error by parsing \n");
		}
		free(buffer.text);
		flag = 1;
	}
	reading_xml_tree(ret,  option);
	strncpy(answer,answerbuf,128);
	printf("%s", answer);
	return 0;
}

void must_have(void)
{
	tree_mode = check_tree;
	reading_xml_tree(ret, NULL);
	if(error_flag)
		printf("\nIf messages are shown above its not guarantied\n"
			"that the Kernel will be work properly after installing\n"
			"or your System does't support the above HW\n "
			"for further help please refer to the README\n");
}
