#!/usr/bin/python

# WARNING! This file will also be sourced by shell scripts!
# Use only syntax which is both python- and sh-compatible!

# How big inline needs to be to be analyzed? Min 1, max 9.
# (Used to exclude one-liners and such)
min_lines=1

# Shell commands (usually grep) which remove filenames which must not be
# included into inline measurement rebuilds.
exclude_files="\
  grep -v '^tools/' \
| grep -v '^scripts/' \
| grep -v '^samples/' \
| grep -v '^Documentation/' \
| grep -v '^drivers/staging/' \
\
| grep -v '^arch/[^x]' \
| grep -v '^arch/x[^8]' \
| grep -v '^arch/x8[^6]' \
| grep -v '^arch/x86/.*_32\.h:' \
"
# ^^^ the second group of "greps" is arch and build-specific

# How many parallel rebuild jobs do you want?
# (Something like $CPUS/10 would work well enough)
dir_count=19

# How many parallel compilers in each job?
# Note that often jobs spend lots of time in single-threaded final link,
# they will not all sit in "make -jBIGNUM" parallel stage.
# At most, set it to $CPUS-$dir_count. If you don't have tons of RAM, decrease.
make_vmlinux_cmd="nice make -j99 vmlinux"
