#ifndef _RDTSC_H
#define _RDTSC_H
#include <stdint.h>

#include "sys-nr-irq.h"

static inline void rdtsc(uint32_t *edx, uint32_t *eax)
{
	asm volatile ("rdtsc" : "=d" (*edx), "=a" (*eax));
}

static inline void rdtscp(uint32_t *edx, uint32_t *eax, uint32_t *ecx)
{
	asm volatile ("rdtscp" : "=d" (*edx), "=a" (*eax), "=c" (*ecx));
}

static inline void lfence(void)
{
	asm volatile ("lfence" ::: "memory");
}

static inline uint64_t time_init(uint64_t *x)
{
	uint32_t edx, eax;

	*x = sys_nr_irq();

	lfence();
	rdtsc(&edx, &eax);
	return ((uint64_t)edx << 32) | eax;
}

static inline uint64_t time_fini(uint64_t *x)
{
	uint32_t edx, eax;

	lfence();
	rdtsc(&edx, &eax);

	*x = sys_nr_irq();

	return ((uint64_t)edx << 32) | eax;
}
#endif
