#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mman.h>

#include "rdtsc.h"
#include "sys-nr-irq.h"
#include "mv.h"

#define PAGE_SIZE 4096
static unsigned int N;
static unsigned int M;

int num_to_str(char *buf, int size, unsigned long long num);
#define g(p, len, x)	 num_to_str(p, len, x)

void f(unsigned long long x)
{
	struct mean_variance mv;
	void *p;
	unsigned int i;

	p = mmap(NULL, PAGE_SIZE, PROT_READ|PROT_WRITE, MAP_PRIVATE|MAP_ANONYMOUS, -1, 0);
	if (p == MAP_FAILED)
		abort();

	mv_init(&mv);

	g(p, PAGE_SIZE, x);
	g(p, PAGE_SIZE, x);
	g(p, PAGE_SIZE, x);

	i = 0;
	while (i < N) {
		uint64_t t0, t1;
		uint64_t x0, x1;
		uint64_t T;
		unsigned int j;

		t0 = time_init(&x0);
		for (j = 0; j < M; j++)
			g(p, PAGE_SIZE, x);
		t1 = time_fini(&x1);

		if (x1 != x0)
			continue;

		T = t1 - t0;
		mv_update(&mv, T);

		i++;
	}

	mv_print(&mv);

	munmap(p, PAGE_SIZE);
}

int main(int argc, char *argv[])
{
	unsigned long long x;

	if (argc < 3)
		return 1;

	N = atoi(argv[1]);
	M = atoi(argv[2]);

#define _(a)				\
	x = a;				\
	fprintf(stderr, "%llu\t", x);	\
	f(x)

	_(0);
	_(1);
	_(10);
	_(100);
	_(255);
	_(1000);
	_(10000);
	_(65535);
	_(100000);
	_(1000000);
	_(10000000);
	_(100000000);
	_(4294967295);
	_(18446744073709551615ull);

#undef _

	return 0;
}
