#!/bin/sh

# HELP: drop_caches: See <http://git.kernel.org/cgit/linux/kernel/git/torvalds/linux.git/tree/Documentation/sysctl/vm.txt#n176>
#
# To free pagecache:
#	echo 1 > /proc/sys/vm/drop_caches
# To free reclaimable slab objects (includes dentries and inodes):
#	echo 2 > /proc/sys/vm/drop_caches
# To free slab objects and pagecache:
#	echo 3 > /proc/sys/vm/drop_caches
#
# NOTE: Ubuntu/precise: default -> "0" (output of 'cat /proc/sys/vm/drop_caches')

export LANG=C
export LC_ALL=C

PKG_NAME="fio"
PKG_VER="2.2.5"

WORKING_DIR="$HOME/tests/$PKG_NAME"
LOGS_DIR="$WORKING_DIR/logs"

LOG_FILE="results_${PKG_NAME}-${PKG_VER}_$(uname -r).txt"

DMESG_BEFORE="dmesg_$(uname -r)_before-${PKG_NAME}-${PKG_VER}.txt"
DMESG_AFTER="dmesg_$(uname -r)_after-${PKG_NAME}-${PKG_VER}.txt"
DMESG_DIFF="dmesg_$(uname -r)_${PKG_NAME}-${PKG_VER}.diff"

FIO_BIN="${PKG_NAME}-${PKG_VER}"
FIO_OPTS="--name=randread --rw=randread --bs=4k --ioengine=libaio --iodepth=64 --direct=1 --numjobs=1 --size=1024M"

[ -d $WORKING_DIR ] || mkdir -p $WORKING_DIR
[ -d $LOGS_DIR ] || mkdir -p $LOGS_DIR

cd $WORKING_DIR

rm -v -f randread.*
sync && sync && sync

dmesg > $LOGS_DIR/$DMESG_BEFORE

# As suggested by Ming Lei for fio tests with block-loopmq
echo 3 > /proc/sys/vm/drop_caches

$FIO_BIN $FIO_OPTS 2>&1 | tee $LOGS_DIR/$LOG_FILE

# XXX: TODO: Restore default drop_caches settings (value "0" is not allowed)
##echo 0 > /proc/sys/vm/drop_caches

dmesg > $LOGS_DIR/$DMESG_AFTER

rm -v -f randread.*

cd $LOGS_DIR
diff -uprN $DMESG_BEFORE $DMESG_AFTER > $DMESG_DIFF
