#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

static struct timeval start_tv, stop_tv;

// Calculate the difference between two time values.
void tvsub(struct timeval *tdiff, struct timeval *t1, struct timeval *t0)
{
	tdiff->tv_sec = t1->tv_sec - t0->tv_sec;
	tdiff->tv_usec = t1->tv_usec - t0->tv_usec;
	if (tdiff->tv_usec < 0)
		tdiff->tv_sec--, tdiff->tv_usec += 1000000;
}

// Start timing now.
void start()
{
	(void) gettimeofday(&start_tv, (struct timezone *) 0);
}

// Stop timing and return real time in microseconds.
unsigned long long stop()
{
	struct timeval tdiff;

	(void) gettimeofday(&stop_tv, (struct timezone *) 0);
	tvsub(&tdiff, &stop_tv, &start_tv);
	return (tdiff.tv_sec * 1000000 + tdiff.tv_usec);
}

#define MAPSIZE		(100*1024*1024)		// 100 MB
#define NVDIMM_ADDR	0x240000000		// CHANGE THIS!

int main()
{
	int fd, i;
	unsigned long *p, *wp, tmp;
	unsigned long long timeval;

	// WT mapping (normally UC- mapping)
	fd = open("/dev/mem", O_RDWR|O_DSYNC);

	// WB mapping
	// fd = open("/dev/mem", O_RDWR);

	p = mmap(NULL, MAPSIZE, PROT_READ|PROT_WRITE,
				MAP_SHARED, fd, NVDIMM_ADDR);

	start();
	for (i=0, wp=p; i<(MAPSIZE/sizeof(wp)); i++)
		*wp++ = 1;
	timeval = stop();
	printf("Write: %10llu usec\n", timeval);

	start();
	for (i=0, wp=p; i<(MAPSIZE/sizeof(wp)); i++)
		tmp = *wp++;
	timeval = stop();
	printf("Read : %10llu usec\n", timeval);
}
