#ifndef __MEMTEST_LIB_H
#define __MEMTEST_LIB_H

#include <string.h>
#include <stdarg.h>
#include <unistd.h>
#include <time.h>
#include <stdint.h>

#if 0
#define X86_FEATURE_XMM2	(0*32+26) /* "sse2" */

#define __stringify_1(x...)	#x
#define __stringify(x...)	__stringify_1(x)

/* alternative assembly primitive: */
#define ALTERNATIVE(oldinstr, newinstr, feature)			\
									\
      "661:\n\t" oldinstr "\n662:\n"					\
      ".section .altinstructions,\"a\"\n"				\
      "	 .long 661b - .\n"			/* label           */	\
      "	 .long 663f - .\n"			/* new instruction */	\
      "	 .word " __stringify(feature) "\n"	/* feature bit     */	\
      "	 .byte 662b-661b\n"			/* sourcelen       */	\
      "	 .byte 664f-663f\n"			/* replacementlen  */	\
      ".previous\n"							\
      ".section .discard,\"aw\",@progbits\n"				\
      "	 .byte 0xff + (664f-663f) - (662b-661b)\n" /* rlen <= slen */	\
      ".previous\n"							\
      ".section .altinstr_replacement, \"ax\"\n"			\
      "663:\n\t" newinstr "\n664:\n"		/* replacement     */	\
      ".previous"

#define alternative(oldinstr, newinstr, feature)			\
	asm volatile (ALTERNATIVE(oldinstr, newinstr, feature) : : : "memory")

#define mb() alternative("lock; addl $0,0(%%esp)", "mfence", X86_FEATURE_XMM2)

#define barrier() asm volatile("" ::: "memory")
#endif

#define mb()	__sync_synchronize()

#define PAGE_SIZE (1 << 12)
#define pa2pfn(x)	(x >> 12)
#define pfn2pa(x)	(x << 12)

#define ALIGN(x,a)		__ALIGN_MASK(x,(typeof(x))(a)-1)
#define __ALIGN_MASK(x,mask)	(((x)+(mask))&~(mask))
#define PAGE_ALIGN(addr) ALIGN(addr, PAGE_SIZE)

#if 0
#ifndef __WORDSIZE
#define __WORDSIZE (__SIZEOF_LONG__ * 8)
#endif

#define DIV_ROUND_UP(n,d) (((n) + (d) - 1) / (d))

#define BITS_PER_LONG __WORDSIZE
#define BITS_PER_BYTE           8
#define BITS_TO_LONGS(nr)       DIV_ROUND_UP(nr, BITS_PER_BYTE * sizeof(long))

static inline void set_bit(int nr, unsigned long *addr)
{
	addr[nr / BITS_PER_LONG] |= 1UL << (nr % BITS_PER_LONG);
}

static inline void clear_bit(int nr, unsigned long *addr)
{
	addr[nr / BITS_PER_LONG] &= ~(1UL << (nr % BITS_PER_LONG));
}

static int test_bit(unsigned int nr, const unsigned long *addr)
{
	return ((1UL << (nr % BITS_PER_LONG)) &
		(((unsigned long *)addr)[nr / BITS_PER_LONG])) != 0;
}
#endif

extern int debug;

static inline void dprint(char *fmt, ...)
{
	va_list arg;

	if (!debug)
		return;

	va_start(arg, fmt);
	vprintf(fmt, arg);
	va_end(arg);
}

static inline void fmt_die(char *fmt, ...)
{
	va_list arg;

	va_start(arg, fmt);
	vprintf(fmt, arg);
	va_end(arg);

	exit(-1);
}

static inline void die(char *s)
{
	fmt_die("%s", s);
}

static inline void *wmalloc_align(int size)
{
	void *p;

	p = mmap(NULL, size, PROT_READ|PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);

	if (p == MAP_FAILED) {
		perror("posix_memalign");
		die("posix_memalign fail.\n");
	}

	return p;
}

typedef uint64_t u64;

static inline u64 time_ns()
{
    struct timespec ts;

    clock_gettime(CLOCK_MONOTONIC, &ts);
    return ts.tv_sec * (u64)1000000000 + ts.tv_nsec;
}
#endif
