#ifndef __SYS_WRAP_H
#define __SYS_WRAP_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include <linux/kvm.h>

typedef __u64 u64;
typedef __s64 s64;

typedef __u32 u32;
typedef __s32 s32;

typedef __u16 u16;
typedef __s16 s16;

typedef __u8  u8;
typedef __s8  s8;

#define PAGE_SIZE (1 << 12)
#define pa2pfn(x)	(x >> 12)
#define pfn2pa(x)	(x << 12)

#define ALIGN(x,a)		__ALIGN_MASK(x,(typeof(x))(a)-1)
#define __ALIGN_MASK(x,mask)	(((x)+(mask))&~(mask))
#define PAGE_ALIGN(addr) ALIGN(addr, PAGE_SIZE)

//#define DEBUG

#ifdef DEBUG
#define dprintf(fmt, args...)	printf(fmt, ##args)
#else
#define dprintf(fmt, args...)
#endif

#define X86_FEATURE_XMM2	(0*32+26) /* "sse2" */

#define __stringify_1(x...)	#x
#define __stringify(x...)	__stringify_1(x)

/* alternative assembly primitive: */
#define ALTERNATIVE(oldinstr, newinstr, feature)			\
									\
      "661:\n\t" oldinstr "\n662:\n"					\
      ".section .altinstructions,\"a\"\n"				\
      "	 .long 661b - .\n"			/* label           */	\
      "	 .long 663f - .\n"			/* new instruction */	\
      "	 .word " __stringify(feature) "\n"	/* feature bit     */	\
      "	 .byte 662b-661b\n"			/* sourcelen       */	\
      "	 .byte 664f-663f\n"			/* replacementlen  */	\
      ".previous\n"							\
      ".section .discard,\"aw\",@progbits\n"				\
      "	 .byte 0xff + (664f-663f) - (662b-661b)\n" /* rlen <= slen */	\
      ".previous\n"							\
      ".section .altinstr_replacement, \"ax\"\n"			\
      "663:\n\t" newinstr "\n664:\n"		/* replacement     */	\
      ".previous"

#define alternative(oldinstr, newinstr, feature)			\
	asm volatile (ALTERNATIVE(oldinstr, newinstr, feature) : : : "memory")

#define mb() alternative("lock; addl $0,0(%%esp)", "mfence", X86_FEATURE_XMM2)

#define barrier() asm volatile("" ::: "memory")

static inline void fmt_die(char *fmt, ...)
{
	va_list arg;

	va_start(arg, fmt);
	vprintf(fmt, arg);
	va_end(arg);

	exit(-1);
}

static inline void die(char *s)
{
	fmt_die("%s", s);
}

static inline void *wmalloc(int size)
{
	void *p = malloc(size);

	if (!p)
		die("alloc fail.\n");

	memset(p, 0, size);
	return p;
}

static inline void wfree(void *p)
{
	free(p);
}

static inline void *wmalloc_align(int size)
{
	void *p;

	p = mmap(NULL, size, PROT_READ|PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);

	dprintf("P:%p.\n", p);

	if (p == MAP_FAILED) {
		perror("posix_memalign");
		die("posix_memalign fail.\n");
	}

	return p;
#if 0
	int ret;

	ret = posix_memalign(&p, PAGE_SIZE, size);
	if (ret) {
		perror("posix_memalign");
		die("posix_memalign fail.\n");
	}

	return p;
#endif	
}

extern int wsprintf(char *buf, const char *fmt, ...);
extern void *our_memcpy(void *dest, const void *src, size_t count);
#endif
