#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/kprobes.h>

static long unset_bsp_if_set(void *obj)
{
	u32 l, h;

	rdmsr(MSR_IA32_APICBASE, l, h);
	if (l & MSR_IA32_APICBASE_BSP) {
		l &= ~MSR_IA32_APICBASE_BSP;
		wrmsr(MSR_IA32_APICBASE, l, h);
	}

	return 0;
}

static int __init gci_init(void)
{
	smp_call_function(unset_bsp_if_set, NULL, true);

	return 0;
}

static void __exit gci_exit(void)
{
}

module_init(gci_init)
module_exit(gci_exit)
MODULE_LICENSE("GPL");
