#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/kprobes.h>

static inline bool is_bsp(int cpu)
{
	u32 l, h;

	rdmsr(MSR_IA32_APICBASE, l, h);

	return (l & MSR_IA32_APICBASE_BSP) ? true : false;
}

static void gci_pr(void *obj)
{
	int cpu, apic, bios_apic;

	cpu = smp_processor_id();
	apic = per_cpu(x86_cpu_to_apicid, cpu);
	bios_apic = per_cpu(x86_bios_cpu_apicid, cpu);

	printk("cpu: %d bios_apic: %d apic: %d %s\n", cpu, bios_apic, apic, is_bsp(cpu) ? "BSP" : "AP");
}

static int __init gci_init(void)
{
	gci_pr(NULL);
	smp_call_function(gci_pr, NULL, true);

	return 0;
}

static void __exit gci_exit(void)
{
}

module_init(gci_init)
module_exit(gci_exit)
MODULE_LICENSE("GPL");
