#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <fcntl.h>
#include <unistd.h>

int consume_usr(unsigned int seconds)
{
	volatile long count = 0;
	struct timespec ts1, ts2, ts;
	unsigned long time_diff_us = 0;
	unsigned int i, loops;

	loops = seconds; /* 1s one loop */
	while (loops--) {
		clock_gettime(CLOCK_MONOTONIC, &ts1);
		time_diff_us = 0;
		while (time_diff_us < 1000000) {
			struct timespec ts3, ts4;
			unsigned long time_diff_us2 = 0;

			clock_gettime(CLOCK_MONOTONIC, &ts3);
			while (time_diff_us2 < 500) {
				for (i = 0; i < 1234; i++) count++;
				clock_gettime(CLOCK_MONOTONIC, &ts4);
				time_diff_us2 = (ts4.tv_sec * 1000000 + ts4.tv_nsec / 1000) - (ts3.tv_sec * 1000000 + ts3.tv_nsec / 1000);
			}

			ts.tv_sec = 0;
			ts.tv_nsec = 1000 * 450;
        	nanosleep(&ts, NULL);

			clock_gettime(CLOCK_MONOTONIC, &ts2);
			time_diff_us = (ts2.tv_sec * 1000000 + ts2.tv_nsec / 1000) - (ts1.tv_sec * 1000000 + ts1.tv_nsec / 1000);
		}
	}

	return 0;
}

char *g_buf;
int g_len;
int g_fd;

/* target: make high sys which is 100% */
static void make_highsys(void)
{
	lseek(g_fd, 0, SEEK_SET);
	write(g_fd, g_buf, g_len);
}

int consume_sys(unsigned int seconds)
{
	struct timespec ts1, ts2;
	unsigned long time_diff_us = 0;
	unsigned int loops;

	loops = seconds; /* 1s one loop */
	while (loops--) {
		clock_gettime(CLOCK_MONOTONIC, &ts1);
		time_diff_us = 0;
		while (time_diff_us < 1000000) {
			make_highsys();
			clock_gettime(CLOCK_MONOTONIC, &ts2);
			time_diff_us = (ts2.tv_sec * 1000000 + ts2.tv_nsec / 1000) - (ts1.tv_sec * 1000000 + ts1.tv_nsec / 1000);
		}
	}

	return 0;
}


int main(int argc, char *argv[])
{
	unsigned int i;
	char name[128] = {0};

	g_len = 4096 * 100;
	g_buf = malloc(g_len);
	if (!g_buf) {
		printf("malloc failure\n");
		return -1;
	}

	for (i = 0; i < g_len; i += 4096)
		g_buf[i] = 1;
   
	snprintf(name, 128, "/tmp/usr_sys.txt");
	g_fd = open(name, O_RDWR|O_CREAT);
	if (g_fd < 0) {
		free(g_buf);
		printf("file open failure\n");
		return -1;
	}

	while (1) {
		if (argc < 2)
			consume_usr(60);
		consume_sys(10);
	}

	while (1)
		sleep(100);

	free(g_buf);
	close(g_fd);

	return 0;
}
