top_func()
{
	local PROC_STAT_FILE DENORM
	local interval proc_stat_str1 proc_stat_str2

	PROC_STAT_FILE="/proc/$1/stat"
	interval="$2" # in second, current 1 second

    #utime stime
    proc_stat_str1=$(cat $PROC_STAT_FILE | cut -d " " -f 14,15)
    sleep $interval
    proc_stat_str2=$(cat $PROC_STAT_FILE | cut -d " " -f 14,15)

	if [ ! -f /proc/$1/stat ]; then
		echo "Process exit"
		exit -1
	fi

    show_proc_stat_field_util()
    {
        local left=$1 right=$2 denorm=$3
    	local name=$4
    	local delta zhengshu xiaoshu
    
        delta=$(expr $left - $right)
		delta=$(expr 1000 \* $delta)
        delta=$(expr $delta / $denorm)
		zhengshu=$(expr $delta / 10)
		xiaoshu=$(expr $delta % 10)
        echo -n "$zhengshu.$xiaoshu $name "
    }
    
	# Parse proc_stat data
    utime1=$(echo "$proc_stat_str1" | cut -d " " -f1)
    stime1=$(echo "$proc_stat_str1" | cut -d " " -f2)
    
    utime2=$(echo "$proc_stat_str2" | cut -d " " -f1)
    stime2=$(echo "$proc_stat_str2" | cut -d " " -f2)

	DENORM=100 # current sampling period is 1 second
    # 42.3 us,  0.1 sy
    show_proc_stat_field_util $utime2 $utime1 $DENORM "usr, "
    show_proc_stat_field_util $stime2 $stime1 $DENORM "sys"
    echo
}

if [ -z "$1" ]; then
	echo "Please input correct PID"
	exit -1
fi

while true; do
	# <proc/pid/stat>
	if [ ! -f /proc/$1/stat ]; then
		echo "Process $1 does not exist!"
		exit -1
	fi
    top_func $1 1
done
