#! /usr/bin/perl

# $_ is a filename like ../../include/uapi/linux/prctl.h
# convert it to be like: #include <uapi/linux/prctl.h>
# (don't depend on the "uapi" being there)
# input via stdin; output to stdout.
# vi:ts=4

sub addto_mk_allfiles
{
	open(MK, ">>buildall-uapi.mk") || die "Open final buildall-uapi.mk";
	printf MK "  uapi-base.o\n";
	printf MK "\ninclude ./buildall-uapi.allfiles\n";
	close MK;
}

sub addto_buildall
{
	local ($cfile) = $_[0];
	local ($ofile);

	$ofile = $cfile;
	$ofile =~ s/\.c$/.o/;

	open(MK, ">>buildall-uapi.mk") || die "Open buildall-uapi.mk";
	#seek(MK, 1, 2); # to EOF(2) - 1 (so can overwrite the ending newline)
	#seek(MK, tell(MK) - 1, 0); # so can overwrite the ending newline
	printf MK "  %s \\\n", $ofile;
	close MK;

	open(INCL, ">>buildall-uapi.allfiles") || die "Open buildall-uapi.allfiles";
	printf INCL "%s: %s\n", $ofile, $cfile;
	printf INCL "\t\$(c_2_o)\n\n";
	close INCL;
}

sub make_cfile
{
	local ($hdr) = $_[0];
	local ($cfile) = $_[0];

	##print "make_cfile: hdr=$hdr\n";
	##print "make_cfile: cfile.00=$cfile\n";
	$cfile =~ tr/\//./;
	$cfile =~ s/\.h$/.c/;
	##print "make_cfile: cfile.01=$cfile\n";

	open(C, ">$cfile") || die "Create $cfile";

	printf C "#include <stdio.h>\n";
	printf C "#include <stdarg.h>\n";
	printf C "#include <stdint.h>\n";
#	printf C "#include <linux/posix_types.h>\n";
	printf C "#include <%s>\n\n", $hdr;
	printf C "int main(int argc, char *argv[])\n";
	printf C "{ }\n";

	close C;

	addto_buildall($cfile);
}

LINE:
	while ($line = <STDIN>) {
		chomp $line;		# drop ending newline

		# skip if not a .h file
		next LINE if ($line !~ m/\.h$/);
		# TBD: skip any /asm.*posix_types/
		next LINE if ($line =~ "asm.*posix_types");

		$line =~ s@^.*include/@@;
		##$line =~ s@\.h$@@;

		##print "calling make_cfile w/line=$line//\n";
		make_cfile($line);
	} ### < STDIN

	&addto_mk_allfiles();
