/*
 * Utility functions
 *
 * Copyright (C) 2000, Olaf Kirch <okir@caldera.de>
 */
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include "utils.h"

unsigned int
getnum(const char *what, const char *arg, unsigned int min, unsigned int max)
{
	unsigned int	value;
	char		*end;

	value = strtoul(arg, &end, 0);
	if (*end)
		fatal("bad %s value \"%s\"", what, arg);
	
	if (value < min)
		fatal("bad %s value %u, must be less than %u",
			what, value, min);
	if (value > max)
		fatal("bad %s value %u, must be greater than %u",
			what, value, max);
	return value;
}

int
getaddr(const char *arg, struct in_addr *ap)
{
	struct hostent	*hp;

	if (inet_aton(arg, ap))
		return 1;

	if (!(hp = gethostbyname(arg))) {
		herror(arg);
		return 0;
	}

	if (hp->h_addrtype != AF_INET) {
		fprintf(stderr, "%s: no IPv4 address\n", arg);
		return 0;
	}

	*ap = *(struct in_addr *) hp->h_addr;
	return 1;
}

void
printaddr(struct in_addr addr, int resolve)
{
	struct hostent	*hp;

	if (resolve && (hp = gethostbyaddr(&addr, 4, AF_INET))) {
		printf("%s (%s)", hp->h_name, inet_ntoa(addr));
	} else {
		printf("%s", inet_ntoa(addr));
	}
}

void
fatal(const char *fmt, ...)
{
	va_list	ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	exit(1);
}
