#include <sys/types.h>          /* See NOTES */
#include <sys/socket.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

void
main(int argc, char **argv)
{
	int fd[100];
	int i;
	int num_of_interations = 1000000;
	int socks_per_interation = 10;

	if (argc > 1) {
		if (argc != 3) {
			fprintf(stderr, "Usage: %s num_of_interation "
			    "socks_per_inetrations\n", argv[0]);
			exit(1);
		} else {
			num_of_interations = atoi(argv[1]);
			socks_per_interation = atoi(argv[2]);
			if (socks_per_interation > 100) {
				socks_per_interation = 100;
			}
		}
	}
	
	while (num_of_interations--) {
		for (i = 0; i < socks_per_interation; i++) {
			fd[i] = socket(AF_UNIX, SOCK_DGRAM, 0);
		}

		for (i = 0; i < socks_per_interation; i++) {
			close(fd[i]);
		}
	}
}
