#!/bin/bash

if [ $# -lt 3 ]
then
	echo "Usage: $0 <image name> <super block dump file> <mount point>"
	exit 1
fi

make

imgname=$1
dmpfile=$2
mntpt=$3

dumpe2fs -h $imgname > $dmpfile

blk_per_grp=`grep 'Blocks per group' $dmpfile | cut -d : -f 2`
ind_per_grp=`grep 'Inodes per group' $dmpfile | cut -d : -f 2`
blk_sz=`grep 'Block size' $dmpfile | cut -d : -f 2`
blk_count=`grep 'Block count' $dmpfile | cut -d : -f 2`
free_blk_count=`grep 'Free blocks' $dmpfile | cut -d : -f 2`
blk_grp=`expr $blk_count \/ $blk_per_grp`
if [ `expr $blk_count \% $blk_per_grp` -ne 0 ]
then
	blk_grp=`expr $blk_grp + 1`
fi

mount -t ext2 -o loop -o ro $imgname $mntpt
./cref $mntpt $blk_per_grp $ind_per_grp $blk_sz $blk_grp $blk_count $free_blk_count
umount -f $mntpt

echo "DONE"
