#include <unistd.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <math.h>

#include <linux/fs.h>

unsigned long long dd_cref = 0;
unsigned long long df_cref = 0;
unsigned long long f_cref = 0;
unsigned long long d_cref = 0;
unsigned long long ind_per_grp;
unsigned long long blk_per_grp;
unsigned long long blk_sz;
unsigned long long blk_grp;
unsigned long long blk_cnt;
unsigned long long free_blk_cnt;
unsigned long long *found_in_grp;
unsigned long long dcount;
unsigned long long fcount;

unsigned long long dgrp_cnt(char *f, unsigned long long ino, unsigned long long *dd, unsigned long long *df)
{
	DIR *d;
	struct dirent *dentry;
	unsigned long long j, c = 0, grp, this_grp;
	struct stat stbuf;
	char tmp[500];
	
	for(j = 0; j < blk_grp; j++)
	{
		found_in_grp[j] = 0;
	}

	this_grp = floor(ino / ind_per_grp) - ((ino % ind_per_grp == 0)?1:0);
	if (found_in_grp[this_grp] == 0)
	{
		c++;
	}
		printf("%llu, ", this_grp);
	found_in_grp[this_grp]++;

	d = opendir(f);
	if (d == NULL)
	{
		printf("Error opening directory: %s\n", f);
		return c;
	}
	
	dentry = readdir(d);
	while(dentry != NULL)
	{
		strcpy(tmp, f);
		strcat(tmp, "/");
		strcat(tmp, dentry->d_name);
		
		if (lstat(tmp, &stbuf))
		{
			printf("\nError stat-ing file: %s\n", f);
			return -1;
		}
	
		grp = floor(dentry->d_ino / ind_per_grp) - ((ino % ind_per_grp == 0)?1:0);
		if (found_in_grp[grp] == 0)
		{
			if (S_ISDIR(stbuf.st_mode))
				(*dd)++;
			else
				(*df)++;
			
			c++;
		}
			printf("%llu, ", grp);
		found_in_grp[grp]++;
		
		dentry = readdir(d);
	}

	printf("\n");

	if (closedir(d) == -1)
	{
		printf("Error closing directory: %s\n", f);
		return c;
	}

	return c;
}

unsigned long long fgrp_cnt(char *f, unsigned long long ino)
{
	int err = 0;
	int fd;
	unsigned long long blksize;
	off_t filesz;
	unsigned long long fileblks, blk;
	
	unsigned long long c = 0, j, grp;

	for(j = 0; j < blk_grp; j++)
	{
		found_in_grp[j] = 0;
	}

	grp = floor(ino / ind_per_grp) - ((ino % ind_per_grp == 0)?1:0);
	if (found_in_grp[grp] == 0)
	{
		c++;
	}
		printf("%llu, ", grp);
	found_in_grp[grp]++;
	
	fd = open(f, O_RDONLY | O_NONBLOCK);
	if (fd == -1)
	{
		perror(f);
		return c;
	}

	blksize = blk_sz;
	
	filesz = lseek(fd, 0, SEEK_END);
	lseek(fd, 0, SEEK_SET);
	fileblks = (filesz + blksize-1) / blksize;

	err = 0;
	for(blk = 0; blk < fileblks; blk++)
	{
		unsigned long long int devblk = blk;

		if (ioctl(fd, FIBMAP, &devblk) == -1)
		{
			if (errno == -EPERM)
			{
				fprintf(stderr, "got root?\n");
				exit(1);
			}
			printf("IOCTL error - %llu: %d (%s)\n",blk, errno, strerror(errno));
			err++;
		}
		else
		{
			grp = floor(devblk / blk_per_grp);
			if (found_in_grp[grp] == 0)
			{
				c++;
			}
				printf("%llu, ", grp);
			found_in_grp[grp]++;
		}
	}

	printf("\n");

	close(fd);
	return c;
}

int rec(char *f)
{
	DIR *d;
	struct dirent *dentry;
	struct stat stbuf;
	char tmp[500];
	unsigned long long t;

	if (lstat(f, &stbuf))
	{
		printf("\nError stat-ing file: %s\n", f);
		return -1;
	}
	
	if (S_ISDIR(stbuf.st_mode))
	{
		dcount++;
		printf("\nD: %s (%lu)\n", f, stbuf.st_ino);
		t = (dgrp_cnt(f, stbuf.st_ino, &dd_cref, &df_cref) - 1);
		printf("\nCL = %llu\n", t);
		d_cref += t;
		
		d = opendir(f);
		if (d == NULL)
		{
			printf("\nError opening directory: %s\n", f);
			return -1;
		}

		dentry = readdir(d);
		while(dentry != NULL)
		{
			strcpy(tmp, f);
			strcat(tmp, "/");
			strcat(tmp, dentry->d_name);

			if (strcmp(dentry->d_name, ".") == 0 || strcmp(dentry->d_name, "..") == 0)
			{
				dentry = readdir(d);
				continue;
			}

			dentry = readdir(d);
			rec(tmp);
		}

		if (closedir(d) == -1)
		{
			printf("\nError closing directory: %s\n", f);
			return -1;
		}
	}
	else if (S_ISREG(stbuf.st_mode))
	{
		fcount++;
		printf("\nF: %s (%lu)\n", f, stbuf.st_ino);
		t = (fgrp_cnt(f, stbuf.st_ino) - 1);
		printf("\nCL = %llu\n", t);
		f_cref += t;
	}

	return 0;
}

int main(int argc, char *argv[])
{
	char a;
	char *tmp;
	tmp = &a;

	free_blk_cnt = strtoull(argv[7], &tmp, 10);
	if (strcmp(tmp, "\0") != 0)
	{
		perror("Invalid argument - free_blk_cnt: ");
		exit(1);
	}
	
	blk_cnt = strtoull(argv[6], &tmp, 10);
	if (strcmp(tmp, "\0") != 0)
	{
		perror("Invalid argument - blk_cnt: ");
		exit(1);
	}

	blk_grp = strtoull(argv[5], &tmp, 10);
	if (strcmp(tmp, "\0") != 0)
	{
		perror("Invalid argument - blk_grp: ");
		exit(1);
	}

	blk_sz = strtoull(argv[4], &tmp, 10);
	if (strcmp(tmp, "\0") != 0)
	{
		perror("Invalid argument - blk_sz: ");
		exit(1);
	}

	ind_per_grp = strtoull(argv[3], &tmp, 10);
	if (strcmp(tmp, "\0") != 0)
	{
		perror("Invalid argument - ind_per_grp: ");
		exit(1);
	}

	blk_per_grp = strtoull(argv[2], &tmp, 10);
	if (strcmp(tmp, "\0") != 0)
	{
		perror("Invalid argument - blk_per_grp: ");
		exit(1);
	}

	found_in_grp = (unsigned long long *) malloc(sizeof(unsigned long long )*blk_grp);
	if (found_in_grp == NULL)
	{
		printf("\nError in allocating memory for test operation\n");
		exit(1);
	}

	d_cref = 0;
	f_cref = 0;
	dd_cref = 0;
	df_cref = 0;
	
	rec(argv[1]);

	printf("\n-------------------------------------------------------\n");
	printf("\nNumber of files = %llu\n", fcount);
	printf("\nNumber of directories = %llu\n", dcount);
	printf("\nTotal size = %llu KB\n", blk_cnt*blk_sz/1024);
	printf("\nTotal data stored = %llu KB\n", blk_sz*(blk_cnt-free_blk_cnt)/1024);
	printf("\nSize of block groups = %llu KB\n", blk_sz*blk_per_grp/1024);
	printf("\nNumber of inodes per block group = %llu\n", ind_per_grp);
	printf("\nNo. of cross references between directories and sub-directories = %llu\n", dd_cref);
	printf("\nNo. of cross references between directories and file = %llu\n", df_cref);
	printf("\nTotal no. of cross references = %llu (dir ref = %llu, file ref = %llu)", d_cref+f_cref, d_cref, f_cref);
	printf("\n-------------------------------------------------------\n");

	return 0;
}
