#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<sys/stat.h>
#include	<sys/types.h>
#include	<sys/time.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	"sync_file_range.h"
#define		O_DIRECT	040000
#define		filesize	1048576
#define		chunksize	1048576	
#define 	count		50

struct timeval t1, t2;

int main()
{
	int fd=-1;
	char *buf;
	char name[50];
	int i, size, writesize, offset;
	unsigned long long diff;
	for(i = 0; i < count; i ++)
		{
			memset(name, 0x00, sizeof(name));
			sprintf(name, "%s/%04d.txt", "/tmp/test", i);
			buf = (char *)valloc(chunksize); 
			if(buf == NULL)
				{
					printf("\n valloc failed\n");
					return -1;
				}		 
			memset(buf,'0',chunksize);
			fd = open(name, O_CREAT | O_RDWR, 0);
			if(fd == -1)
				{
					printf("\n Error opening file \n");
					return -1;
				}
		
			size = filesize;
			offset = 0;
			gettimeofday(&t1,NULL);
			while(1) 
			{
				if(chunksize <= size) 
					{
						writesize = chunksize;
					} 
				else 
					{
						writesize = size;
					}
				write(fd, buf, writesize);
				sync_file_range(fd, offset, writesize, SYNC_FILE_RANGE_WAIT_BEFORE | SYNC_FILE_RANGE_WRITE | SYNC_FILE_RANGE_WAIT_AFTER);
				posix_fadvise(fd, offset, writesize, POSIX_FADV_DONTNEED);
				size -= writesize;
				offset += writesize;
				if(size <= 0)
					break;
			}
			gettimeofday(&t2,NULL);
			diff = ((t2.tv_sec*1000000ULL)+t2.tv_usec) - ((t1.tv_sec*1000000ULL)+t1.tv_usec);
			printf("%Ld\n", diff);	
			close(fd);
			free(buf);
		}
	return 0;
}
						
