#!/bin/bash

CC="gcc -ggdb3"

CFLAGS="-march=native  -mno-mmx -mno-sse2 -mno-3dnow -mno-avx -falign-jumps=1 -falign-loops=1 -mno-fp-ret-in-387 -mpreferred-stack-boundary=4 -mskip-rax-setup -fno-strict-aliasing -fno-strict-overflow -fconserve-stack"

$CC -O3 -o ticket test.c -lpthread -lm

$CC -O3 $CFLAGS -D ATOMIC=1 -o atomic test.c -lpthread -lm
$CC -O3 $CFLAGS -D ATOMIC=1 -D COND=1 -o atomic-cond test.c -lpthread -lm
$CC -O3 $CFLAGS -D ATOMIC=1 -D REF=1 -o atomic-ref test.c refcount.c -lpthread -lm
$CC -O3 $CFLAGS -D ATOMIC=1 -D REF=1 -D REF_INLINE=1 -o atomic-ref2 test.c refcount.c -lpthread -lm

$CC -O3 -D QUEUE=1 -o qspinlock test.c qspinlock.c -lpthread -lm
$CC -O3 -D QUEUE=1 -D PENDING=1 -o qspinlock-pending test.c qspinlock.c -lpthread -lm
$CC -O3 -D QUEUE=1 -D PENDING=1 -D OPT=1 -o qspinlock-pending-opt test.c qspinlock.c -lpthread -lm
$CC -O3 -D QUEUE=1 -D PENDING=1 -D OPT=1 -D OPT2=1 -o qspinlock-pending-opt2 test.c qspinlock.c -lpthread -lm

$CC -O3 -D QUEUE=1 -o waiman test.c waiman.c -lpthread -lm
