#ifndef _BARRIER_H
#define _BARRIER_H

#define likely(x)	__builtin_expect(!!(x), 1)
#define unlikely(x)	__builtin_expect(!!(x), 0)

#define NULL ((void *)0)

#ifndef __always_inline
#define __always_inline		inline __attribute__((always_inline))
#endif

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
typedef unsigned long long u64;

typedef signed char s8;
typedef signed short s16;
typedef signed int s32;
typedef signed long long s64;

typedef _Bool bool;

#define false (0)
#define true (1)

# define UINT_MAX             (4294967295U)

#define barrier()	asm volatile("" : : : "memory")
#define mb()		asm volatile("mfence" ::: "memory")
#define wmb()		asm volatile("sfence" ::: "memory")
#define rmb()		asm volatile("lfence" ::: "memory")

#define smp_mb()	mb()
#define smp_wmb()	barrier()
#define smp_rmb()	barrier()

#define ACCESS_ONCE(x) (*(volatile typeof(x) *)&(x))

#define smp_store_release(p, v)						\
do {									\
	barrier();							\
	ACCESS_ONCE(*p) = (v);						\
} while (0)

#define smp_load_acquire(p)						\
({									\
	typeof(*p) ___p1 = ACCESS_ONCE(*p);				\
	barrier();							\
	___p1;								\
})

#define cpu_relax()	asm volatile ("rep; nop" ::: "memory")

#endif /* _BARRIER_H */
