#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

#include "ntl_user.h"

static void *test_func(void *data)
{
	//fprintf(stderr, "============> %s: start data: %p, time: %ld.\n", __func__, data, time(NULL));
#if 0
	while (1) {
		fprintf(stdout, "============> %s: data: %p, time: %ld.\n", __func__, data, time(NULL));
		sleep(1);
	}
#endif
	return data;
}

int main(int argc, char *argv[])
{
	int err, i, num;
	void *data = NULL;
	struct ntl_thread_id id;
	struct timeval tm1, tm2;
	long diff;
	double speed;

	if (argc >= 2)
		num = atoi(argv[1]);
	else
		num = 10;

	fprintf(stderr, "============> %s: data: %p, num: %d, pid: %d.\n", __func__, data, num, getpid());

	gettimeofday(&tm1, NULL);
	for (i=0; i<num; ++i) {
		err = ntl_thread_create(&id, test_func, data+i);
		if (err) {
			fprintf(stderr, "Failed to create thread: err: %d.\n", err);
			return err;
		}
		//fprintf(stderr, "============> %d/%d: id: %x\n", i, num, id.id);
	}
	gettimeofday(&tm2, NULL);

	diff = (tm2.tv_sec - tm1.tv_sec)*1000000 + (tm2.tv_usec - tm1.tv_usec);
	speed = (double)diff/(double)num;

	printf("num: %d, diff: %ld, speed: %f.\n", num, diff, speed);

	while (0) {
		printf("============> %s: %ld.\n", __func__, time(NULL));
		sleep(10);
	}

	return 0;
}
