/*
 * 2007+ Copyright (c) Evgeniy Polyakov <johnpol@2ka.mipt.ru>
 * All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __NTL_SCHED_H
#define __NTL_SCHED_H

#include "ntl.h"

int ntl_sched_add(struct ntl_thread *th);
void ntl_sched_remove(struct ntl_thread *th);

int ntl_sched_init(void);
void ntl_sched_exit(void);

struct ntl_thread *ntl_thread_get(int tid);

int ntl_schedule(void);

void ntl_recalc_current(void);
void ntl_sched_find_current(struct ntl_thread **oldp, struct ntl_thread **newp);

#endif /* __NTL_SCHED_H */
