/*
 * 2007+ Copyright (c) Evgeniy Polyakov <johnpol@2ka.mipt.ru>
 * All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __NTL_H
#define __NTL_H

#include <sys/time.h>

#include "context.h"
#include "list.h"

#define __ALIGN_MASK(x,mask)	(((x)+(mask))&~(mask))
#define ALIGN(x,a)		__ALIGN_MASK(x,(typeof(x))(a)-1)

#define PAGE_SIZE	4096
#define BITS_PER_LONG 	32 

#define BITS_TO_LONGS(bits) \
	(((bits)+BITS_PER_LONG-1)/BITS_PER_LONG)
#define DECLARE_BITMAP(name,bits) \
	unsigned long name[BITS_TO_LONGS(bits)]

#define min_t(type,x,y) \
	({ type __x = (x); type __y = (y); __x < __y ? __x: __y; })
#define max_t(type,x,y) \
	({ type __x = (x); type __y = (y); __x > __y ? __x: __y; })

#undef offsetof
#ifdef __compiler_offsetof
#define offsetof(TYPE,MEMBER) __compiler_offsetof(TYPE,MEMBER)
#else
#define offsetof(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)
#endif

/**
 * container_of - cast a member of a structure out to the containing structure
 * @ptr:	the pointer to the member.
 * @type:	the type of the container struct this is embedded in.
 * @member:	the name of the member within the struct.
 *
 */
#define container_of(ptr, type, member) ({			\
        const typeof( ((type *)0)->member ) *__mptr = (ptr);	\
        (type *)( (char *)__mptr - offsetof(type,member) );})

struct ntl_thread
{
	struct list_head		thread_cache_entry;
	struct sigframe			frame;

	int				stack_size;
	void				*guard_page;
	void				*stack;

	int				tid;

	struct timeval			start;
	struct list_head		task_entry;
	int				prio, last;

	int				run_queue_num;

	void				*priv;
	void 				*(*func)(void *);

	unsigned long			flags;
};

//#define ulog(f, a...) do { fprintf(stderr, f, ##a); fflush(stderr); } while(0)
#define ulog(f, a...) do {} while (0)

void ntl_thread_exit(struct ntl_thread *th);
int ntl_arch_call_func(void *(*func)(void *), void *data, void *stack, unsigned long stack_size);

#endif /* __NTL_H */
