/*
 * 2007+ Copyright (c) Evgeniy Polyakov <johnpol@2ka.mipt.ru>
 * All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __I386_CONTEXT_H
#define __I386_CONTEXT_H

#include <asm/sigcontext.h>

struct __sigcontext {
	unsigned long gs;
	unsigned long fs;
	unsigned long es;
	unsigned long ds;
	unsigned long edi;
	unsigned long esi;
	unsigned long ebp;
	unsigned long esp;
	unsigned long ebx;
	unsigned long edx;
	unsigned long ecx;
	unsigned long eax;
	unsigned long trapno;
	unsigned long err;
	unsigned long eip;
	unsigned long cs;
	unsigned long eflags;
	unsigned long esp_at_signal;
	unsigned long ss;
	struct _fpstate __user * fpstate;
	unsigned long oldmask;
	unsigned long cr2;
};

#define _NSIG_WORDS	2

struct sigframe
{
	char *pretcode;
	int sig;
	struct __sigcontext sc;
	struct _fpstate fpstate;
	unsigned long extramask[_NSIG_WORDS-1];
	char retcode[8];
};

void ntl_arch_sched_sighandler(int signo __attribute__ ((unused)));
void ntl_arch_sched_sigsetup(int signo __attribute__ ((unused)));

#endif /* __I386_CONTEXT_H */
