#define inline inline __attribute__((always_inline))

typedef signed char s8;
typedef unsigned char u8;
typedef signed short s16;
typedef unsigned short u16;
typedef signed int s32;
typedef unsigned int u32;
typedef signed long long s64;
typedef unsigned long long u64;

typedef _Bool bool;

struct ftrace_branch_data {
  unsigned long miss_hit[2];
};

#define if(cond, ...) __trace_if( (cond , ## __VA_ARGS__) )
#define __trace_if(cond) \
	if (__builtin_constant_p((cond)) ? !!(cond) :			\
	({								\
		int ______r;						\
		static struct ftrace_branch_data ______f;		\
		______r = !!(cond);					\
		______f.miss_hit[______r]++;				\
		______r;						\
	}))

extern int fls(int x);
extern int fls64(u64 x);

/* this should never be called */
extern __attribute__((const, noreturn, error("gcc is screwed")))
int ____ilog2_NaN(void);

#define ilog2(n)				\
(						\
	__builtin_constant_p(n) ? (		\
		(n) == 0 ? ____ilog2_NaN() :	\
		(n) & (1ULL << 63) ? 63 :	\
		(n) & (1ULL << 62) ? 62 :	\
		(n) & (1ULL << 61) ? 61 :	\
		(n) & (1ULL << 60) ? 60 :	\
		(n) & (1ULL << 59) ? 59 :	\
		(n) & (1ULL << 58) ? 58 :	\
		(n) & (1ULL << 57) ? 57 :	\
		(n) & (1ULL << 56) ? 56 :	\
		(n) & (1ULL << 55) ? 55 :	\
		(n) & (1ULL << 54) ? 54 :	\
		(n) & (1ULL << 53) ? 53 :	\
		(n) & (1ULL << 52) ? 52 :	\
		(n) & (1ULL << 51) ? 51 :	\
		(n) & (1ULL << 50) ? 50 :	\
		(n) & (1ULL << 49) ? 49 :	\
		(n) & (1ULL << 48) ? 48 :	\
		(n) & (1ULL << 47) ? 47 :	\
		(n) & (1ULL << 46) ? 46 :	\
		(n) & (1ULL << 45) ? 45 :	\
		(n) & (1ULL << 44) ? 44 :	\
		(n) & (1ULL << 43) ? 43 :	\
		(n) & (1ULL << 42) ? 42 :	\
		(n) & (1ULL << 41) ? 41 :	\
		(n) & (1ULL << 40) ? 40 :	\
		(n) & (1ULL << 39) ? 39 :	\
		(n) & (1ULL << 38) ? 38 :	\
		(n) & (1ULL << 37) ? 37 :	\
		(n) & (1ULL << 36) ? 36 :	\
		(n) & (1ULL << 35) ? 35 :	\
		(n) & (1ULL << 34) ? 34 :	\
		(n) & (1ULL << 33) ? 33 :	\
		(n) & (1ULL << 32) ? 32 :	\
		(n) & (1ULL << 31) ? 31 :	\
		(n) & (1ULL << 30) ? 30 :	\
		(n) & (1ULL << 29) ? 29 :	\
		(n) & (1ULL << 28) ? 28 :	\
		(n) & (1ULL << 27) ? 27 :	\
		(n) & (1ULL << 26) ? 26 :	\
		(n) & (1ULL << 25) ? 25 :	\
		(n) & (1ULL << 24) ? 24 :	\
		(n) & (1ULL << 23) ? 23 :	\
		(n) & (1ULL << 22) ? 22 :	\
		(n) & (1ULL << 21) ? 21 :	\
		(n) & (1ULL << 20) ? 20 :	\
		(n) & (1ULL << 19) ? 19 :	\
		(n) & (1ULL << 18) ? 18 :	\
		(n) & (1ULL << 17) ? 17 :	\
		(n) & (1ULL << 16) ? 16 :	\
		(n) & (1ULL << 15) ? 15 :	\
		(n) & (1ULL << 14) ? 14 :	\
		(n) & (1ULL << 13) ? 13 :	\
		(n) & (1ULL << 12) ? 12 :	\
		(n) & (1ULL << 11) ? 11 :	\
		(n) & (1ULL << 10) ? 10 :	\
		(n) & (1ULL <<  9) ?  9 :	\
		(n) & (1ULL <<  8) ?  8 :	\
		(n) & (1ULL <<  7) ?  7 :	\
		(n) & (1ULL <<  6) ?  6 :	\
		(n) & (1ULL <<  5) ?  5 :	\
		(n) & (1ULL <<  4) ?  4 :	\
		(n) & (1ULL <<  3) ?  3 :	\
		(n) & (1ULL <<  2) ?  2 :	\
		(n) & (1ULL <<  1) ?  1 :	\
		(n) & (1ULL <<  0) ?  0 :	\
		____ilog2_NaN()			\
				   ) :		\
	(sizeof(n) <= 4) ?			\
	__ilog2_u32(n) :			\
	__ilog2_u64(n)				\
 )

static inline __attribute__((const))
int __ilog2_u32(u32 n)
{
 return fls(n) - 1;
}

static inline __attribute__((const))
int __ilog2_u64(u64 n)
{
 return fls64(n) - 1;
}

static inline __attribute__((const))
bool is_power_of_2(unsigned long n)
{
 return (n != 0 && ((n & (n - 1)) == 0));
}

static inline u64 __arch_xprod_64(const u64 m, u64 n, bool bias)
{
 return 0;
}

static inline u32 __div64_const32(u64 n, u32 ___b)
{
 u64 ___res, ___x, ___t, ___m, ___n = (n);
 u32 ___p, ___bias;
 ___p = 1 << ilog2(___b);
 ___m = (~0ULL / ___b) * ___p;
 ___m += (((~0ULL % ___b + 1) * ___p) + ___b - 1) / ___b;
 ___x = ~0ULL / ___b * ___b - 1;
 ___res = ((___m & 0xffffffff) * (___x & 0xffffffff)) >> 32;
 ___t = ___res += (___m & 0xffffffff) * (___x >> 32);
 ___res += (___x & 0xffffffff) * (___m >> 32);
 ___t = (___res < ___t) ? (1ULL << 32) : 0;
 ___res = (___res >> 32) + ___t;
 ___res += (___m >> 32) * (___x >> 32);
 ___res /= ___p;
 if (~0ULL % (___b / (___b & -___b)) == 0) {
  ___n /= (___b & -___b);
  ___m = ~0ULL / (___b / (___b & -___b));
  ___p = 1;
  ___bias = 1;
 } else if (___res != ___x / ___b) {
  ___bias = 1;
  ___m = (~0ULL / ___b) * ___p;
  ___m += ((~0ULL % ___b + 1) * ___p) / ___b;
 } else {
  u32 ___bits = -(___m & -___m);
  ___bits |= ___m >> 32;
  ___bits = (~___bits) << 1;
  if (!___bits) {
   ___p /= (___m & -___m);
   ___m /= (___m & -___m);
  } else {
   ___p >>= ilog2(___bits);
   ___m >>= ilog2(___bits);
  }
  ___bias = 0;
 }
 ___res = __arch_xprod_64(___m, ___n, ___bias);
 ___res /= ___p;
 return ___res;
}

extern u32 __div64_32(u64 *dividend, u32 divisor);

/*
 * This is an example modification to the code that makes the bug
 * "go away". Note that the __base != 0 test is already performed in
 * is_power_of_2() therefore this is redundant code that ought not to
 * change the outcome.  How can __base considered be constant here is
 * a mystery.
 */
#ifdef HIDE_THE_BUG
#define foobar (__base != 0)
#else
#define foobar 1
#endif

#define do_div(n,base)					\
({							\
	u32 __base = (base);				\
	u32 __rem;					\
	(void)(((typeof((n)) *)0) == ((u64 *)0));	\
	if (__builtin_constant_p(__base) &&		\
	    is_power_of_2(__base) && foobar) {		\
		__rem = (n) & (__base - 1);		\
		(n) >>= ilog2(__base);			\
	} else if (__builtin_constant_p(__base) &&	\
		   __base != 0) {			\
		u32 __res_lo, __n_lo = (n);		\
		(n) = __div64_const32(n, __base);	\
		__res_lo = (n);				\
		__rem = __n_lo - __res_lo * __base;	\
	} else 						\
		__rem = __div64_32(&(n), __base);	\
	__rem;						\
})

struct il_priv {
 u64 timestamp;
 u32 beacon_init_val;
 u16 beacon_int;
 u8 max_beacon_itrvl;
};

static u16
il_adjust_beacon(u16 beacon_val, u16 max_beacon_val)
{
 u16 new_val;
 u16 beacon_factor;
#ifndef HIDE_THE_BUG_2
 /* simply removing this code hides the bug too */
 if (!beacon_val)
  return 100U;
#endif
 beacon_factor = (beacon_val + max_beacon_val) / max_beacon_val;
 new_val = beacon_val / beacon_factor;
 if (!new_val)
  new_val = max_beacon_val;
 return new_val;
}

int
il_send_rxon_timing(struct il_priv *il)
{
 u64 tsf = il->timestamp;
 u32 interval_tm, rem;
 u16 beacon_int = il_adjust_beacon(il->beacon_int, il->max_beacon_itrvl);
 interval_tm = beacon_int * 1024;
 rem = do_div(tsf, interval_tm);
 il->beacon_init_val = interval_tm - rem;
 return 0;
}
