/*  
 *  hello-1.c - The simplest kernel module.
 */
#include <linux/module.h>	/* Needed by all modules */
#include <linux/kernel.h>	/* Needed for KERN_INFO */
#include <linux/slab.h>
#include <linux/uaccess.h>

static char *p;

int init_module(void)
{
	phys_addr_t phys;

	printk(KERN_INFO "Hello world 1.\n");

	p = kmalloc(4096, GFP_KERNEL);

	printk(KERN_INFO "p = %p\n", p);

	phys = virt_to_phys(p);
	printk(KERN_INFO "phys = %pap\n", &phys);

	/* 
	 * A non 0 return means init_module failed; module can't be loaded. 
	 */
	return 0;
}

void cleanup_module(void)
{
	phys_addr_t r;

	printk(KERN_INFO "Goodbye world 1.\n");

	r = mcsafe_memcpy(p+2048, p, 2048);

	printk(KERN_INFO "ret = %pap\n", &r);

	if (r == 0)
		kfree(p);
}
